/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientReference;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;

public class RemoteServiceClientRegistry
implements Serializable {
    private static final long serialVersionUID = -7002609161000008043L;
    private static long nextServiceId = 1L;
    private ID containerId;
    private List registrations;
    private AbstractClientContainer container;
    private IConnectContext connectContext;

    public RemoteServiceClientRegistry(AbstractClientContainer container) {
        Assert.isNotNull((Object)container);
        this.containerId = container.getID();
        this.container = container;
        this.registrations = new ArrayList();
    }

    public long getNextServiceId() {
        return nextServiceId++;
    }

    public ID getContainerId() {
        return this.containerId;
    }

    public void registerRegistration(RemoteServiceClientRegistration registration) {
        if (!this.registrations.contains(registration)) {
            this.registrations.add(registration);
        }
    }

    public void unregisterRegistration(RemoteServiceClientRegistration registration) {
        this.registrations.remove(registration);
    }

    public IRemoteServiceReference findServiceReference(IRemoteServiceID serviceID) {
        int i = 0;
        while (i < this.registrations.size()) {
            IRemoteServiceRegistration reg = (IRemoteServiceRegistration)this.registrations.get(i);
            if (serviceID.equals(reg.getID())) {
                return reg.getReference();
            }
            ++i;
        }
        return null;
    }

    public RemoteServiceClientRegistration findServiceRegistration(RemoteServiceClientReference reference) {
        int i = 0;
        while (i < this.registrations.size()) {
            RemoteServiceClientRegistration reg = (RemoteServiceClientRegistration)this.registrations.get(i);
            IRemoteServiceID serviceID = reference.getID();
            if (serviceID.equals(reg.getID())) {
                return reg;
            }
            ++i;
        }
        return null;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, IRemoteFilter remoteFilter) throws ContainerConnectException {
        if (target == null) {
            return this.getRemoteServiceReferences((ID[])null, clazz, remoteFilter);
        }
        if (this.container.getConnectedID() == null) {
            this.container.connect(target, this.connectContext);
        }
        return this.getRemoteServiceReferences(new ID[]{target}, clazz, remoteFilter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, IRemoteFilter filter) throws ContainerConnectException {
        if (target == null) {
            return this.getRemoteServiceReferences(idFilter, clazz, filter);
        }
        if (this.container.getConnectedID() == null) {
            this.container.connect(target, this.connectContext);
        }
        return this.getRemoteServiceReferences(idFilter, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, IRemoteFilter remoteFilter) {
        if (clazz == null) {
            return null;
        }
        ArrayList<IRemoteServiceReference> result = new ArrayList<IRemoteServiceReference>();
        int i = 0;
        while (i < this.registrations.size()) {
            RemoteServiceClientRegistration reg = (RemoteServiceClientRegistration)this.registrations.get(i);
            if (idFilter == null || this.containsID(reg, idFilter)) {
                String[] clazzes = reg.getClazzes();
                boolean found = false;
                int j = 0;
                while (j < clazzes.length && !found) {
                    if (clazz.equals(clazzes[j]) && !result.contains(reg.getReference())) {
                        result.add(reg.getReference());
                        found = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (remoteFilter != null) {
            i = 0;
            while (i < result.size()) {
                RemoteServiceClientReference ref = (RemoteServiceClientReference)result.get(i);
                if (!remoteFilter.match(ref)) {
                    result.remove(i);
                }
                ++i;
            }
        }
        if (result.size() > 0) {
            IRemoteServiceReference[] array = new RemoteServiceClientReference[result.size()];
            result.toArray(array);
            return array.length == 0 ? null : array;
        }
        return null;
    }

    private boolean containsID(RemoteServiceClientRegistration reg, ID[] idFilter) {
        int i = 0;
        while (i < idFilter.length) {
            if (reg.getID().equals(idFilter[i]) || reg.getContainerID().equals((Object)idFilter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IRemoteServiceID getRemoteServiceID(ID containerID, long containerRelativeID) {
        if (containerID.equals((Object)this.containerId)) {
            int i = 0;
            while (i < this.registrations.size()) {
                RemoteServiceClientRegistration reg = (RemoteServiceClientRegistration)this.registrations.get(i);
                if (reg.getID().getContainerRelativeID() == containerRelativeID) {
                    return reg.getID();
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getClazzes(IRemoteServiceReference reference) {
        int i = 0;
        while (i < this.registrations.size()) {
            RemoteServiceClientRegistration reg = (RemoteServiceClientRegistration)this.registrations.get(i);
            if (reg.getReference().equals(reference)) {
                return reg.getClazzes();
            }
            ++i;
        }
        return null;
    }

    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, IRemoteFilter remoteFilter) {
        ArrayList<IRemoteServiceReference> result = new ArrayList<IRemoteServiceReference>();
        int i = 0;
        while (i < this.registrations.size()) {
            RemoteServiceClientRegistration reg = (RemoteServiceClientRegistration)this.registrations.get(i);
            String[] clazzes = reg.getClazzes();
            boolean found = false;
            int j = 0;
            while (j < clazzes.length && !found) {
                if (clazz.equals(clazzes[j]) && !result.contains(reg.getReference())) {
                    result.add(reg.getReference());
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        if (remoteFilter != null) {
            i = 0;
            while (i < result.size()) {
                RemoteServiceClientReference ref = (RemoteServiceClientReference)result.get(i);
                if (!remoteFilter.match(ref)) {
                    result.remove(i);
                }
                ++i;
            }
        }
        if (result.size() > 0) {
            IRemoteServiceReference[] array = new RemoteServiceClientReference[result.size()];
            result.toArray(array);
            return array.length == 0 ? null : array;
        }
        return null;
    }
}

