/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.channel;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.comm.ISynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSChannel;
import org.eclipse.ecf.provider.jms.channel.ConnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.ConnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.ECFMessage;
import org.eclipse.ecf.provider.jms.channel.Ping;
import org.eclipse.ecf.provider.jms.channel.PingResponse;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public abstract class AbstractJMSClientChannel
extends AbstractJMSChannel
implements ISynchAsynchConnection {
    private static final long serialVersionUID = -1381571376210849678L;
    private static final int RESPOND_TO_REQUEST_ERROR_CODE = 32001;
    private static final int DEFAULT_DISCONNECT_WAIT_TIME = 3000;
    private final int disconnectWaitTime = 3000;

    public AbstractJMSClientChannel(ISynchAsynchEventHandler handler, int keepAlive) {
        super(handler, keepAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object connect(ID target, Object data, int timeout) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"connect", (Object[])new Object[]{target, data, new Integer(timeout)});
        if (this.isConnected()) {
            throw new ContainerConnectException("Already connected");
        }
        if (target == null) {
            throw new ContainerConnectException("target must not be null");
        }
        if (!(target instanceof JMSID)) {
            throw new ContainerConnectException("target must be of type JMSID");
        }
        if (!(data instanceof Serializable)) {
            throw new ContainerConnectException("data for connect to target=" + target + " is not serializable", (Throwable)new NotSerializableException());
        }
        Serializable result = null;
        Object object = this.waitResponse;
        synchronized (object) {
            try {
                Serializable connectData = this.setupJMS((JMSID)target, data);
                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("connecting to " + target + "," + data + "," + timeout + ")"));
                result = this.sendAndWait(new ConnectRequestMessage(this.getConnectionID(), this.getLocalID(), (JMSID)target, connectData));
            }
            catch (ECFException e) {
                ECFException except = e;
                ContainerConnectException t = new ContainerConnectException(except.getStatus());
                t.setStackTrace(e.getStackTrace());
                throw t;
            }
            catch (Exception e) {
                ContainerConnectException t = new ContainerConnectException("connect to target=" + target.getName() + " failed", (Throwable)e);
                t.setStackTrace(e.getStackTrace());
                throw t;
            }
        }
        if (result == null) {
            throw new ContainerConnectException("connect to target=" + target.getName() + " refused");
        }
        if (!(result instanceof ConnectResponseMessage)) {
            throw new ContainerConnectException("invalid response for connect to target=" + target.getName());
        }
        Serializable resultData = ((ConnectResponseMessage)result).getData();
        this.fireListenersConnect(new ConnectionEvent((IConnection)this, (Object)resultData));
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"connect", (Object)resultData);
        return resultData;
    }

    protected void handleSynchRequest(String jmsCorrelationID, ECFMessage o) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"respondToRequest", (Object[])new Object[]{jmsCorrelationID, o});
        boolean active = this.isActive();
        try {
            if (o instanceof DisconnectRequestMessage) {
                this.createAndSendMessage(new DisconnectResponseMessage(this.getConnectionID(), o.getTargetID(), o.getSenderID(), null), jmsCorrelationID);
                if (active) {
                    this.handler.handleSynchEvent(new SynchEvent((ISynchConnection)this, (Object)o.getData()));
                }
            } else if (o instanceof Ping && active) {
                this.createAndSendMessage(new PingResponse(o.getTargetID(), o.getSenderID()), jmsCorrelationID);
            }
        }
        catch (Exception e) {
            this.traceAndLogExceptionCatch(32001, "respondToRequest", e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"respondToRequest");
    }

    public Object sendSynch(ID target, byte[] data) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendSynch", (Object[])new Object[]{target, data});
        Serializable result = null;
        if (!this.isActive()) {
            return null;
        }
        this.isStopping = true;
        result = this.sendAndWait(new DisconnectRequestMessage(this.getConnectionID(), this.getLocalID(), target, (Serializable)data), 3000);
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendSynch", (Object)result);
        return result;
    }
}

