/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public class JMSContainerConfig
extends SOContainerConfig {
    private int keepAlive = 30000;

    public JMSContainerConfig(JMSID id, int keepAlive, Map props) {
        super((ID)id, props);
        this.keepAlive = keepAlive;
    }

    public JMSContainerConfig(JMSID id, int keepAlive) {
        super((ID)id);
        this.keepAlive = keepAlive;
    }

    public JMSContainerConfig(JMSID id) {
        this(id, 30000);
    }

    public JMSContainerConfig(String name, int keepAlive, Map props) {
        this((JMSID)IDFactory.getDefault().createID("ecf.namespace.jmsid", name), keepAlive, props);
    }

    public JMSContainerConfig(String name, int keepAlive) {
        this(name, keepAlive, null);
    }

    public JMSContainerConfig(String name) {
        this(name, 30000);
    }

    public JMSContainerConfig(int keepAlive) {
        this(IDFactory.getDefault().createGUID().getName(), keepAlive);
    }

    public JMSContainerConfig() {
        this(30000);
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public Object getPropertyValue(String propName) {
        return this.getProperties().get(propName);
    }

    public String getPropertyString(String propName, String defaultValue) {
        Object val = this.getPropertyValue(propName);
        return val == null ? defaultValue : (String)val;
    }
}

