/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteserviceadmin.ui.rsa.model;

import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRegistrationNode;
import org.eclipse.ecf.remoteservices.ui.util.PropertyUtils;
import org.osgi.framework.ServiceReference;

public class ExportRegistrationNode
extends AbstractRegistrationNode {
    private final RemoteServiceAdmin.ExportRegistration exportRegistration;

    public ExportRegistrationNode(Throwable t, boolean showStack) {
        super(t, showStack);
        this.exportRegistration = null;
    }

    public ExportRegistrationNode(Throwable t) {
        this(t, false);
    }

    public ExportRegistrationNode(RemoteServiceAdmin.ExportRegistration eReg) {
        super(eReg.getException(), false);
        this.exportRegistration = eReg;
    }

    @Override
    protected String getErrorName() {
        return "Export " + super.getErrorName();
    }

    protected RemoteServiceAdmin.ExportRegistration getExportRegistration() {
        return this.exportRegistration;
    }

    protected RemoteServiceAdmin.ExportReference getExportReference() {
        RemoteServiceAdmin.ExportRegistration eReg = this.getExportRegistration();
        return eReg == null ? null : (RemoteServiceAdmin.ExportReference)eReg.getExportReference();
    }

    protected ServiceReference getExportedService() {
        RemoteServiceAdmin.ExportReference eRef = this.getExportReference();
        return eRef == null ? null : eRef.getExportedService();
    }

    @Override
    public String getValidName() {
        return PropertyUtils.convertObjectClassToString(this.getExportedService());
    }

    @Override
    public boolean isClosed() {
        return this.getExportReference() == null;
    }

    @Override
    public ServiceReference getServiceReference() {
        RemoteServiceAdmin.ExportReference exportRef = this.getExportReference();
        return exportRef == null ? null : exportRef.getExportedService();
    }

    @Override
    public void close() {
        if (this.exportRegistration != null) {
            this.exportRegistration.close();
        }
    }
}

