/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.remoteserviceadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ServiceInfoFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.log.LogService;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.remoteserviceadmin";
    private static final String RSA_PROXY_BUNDLE_SYMBOLIC_ID = "org.eclipse.ecf.osgi.services.remoteserviceadmin.proxy";
    private static BundleContext context;
    private static Activator instance;
    private static final String[] DEPENDENT_BUNDLES;
    private ServiceRegistration remoteServiceAdminRegistration;
    private Dictionary rsaProps;
    private ServiceTracker<ContainerTypeDescription, ContainerTypeDescription> ctdTracker;
    private EndpointDescriptionLocator endpointDescriptionLocator;
    private ServiceRegistration<?> iServiceInfoFactoryRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private Object logServiceTrackerLock = new Object();
    private Object saxParserFactoryTrackerLock = new Object();
    private ServiceTracker saxParserFactoryTracker;
    private BundleContext proxyServiceFactoryBundleContext;
    private Collection<ExportRegistration> exportedRegistrations;
    private Collection<ImportRegistration> importedRegistrations;
    private Map<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> remoteServiceAdmins = new HashMap<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin>(1);

    static {
        DEPENDENT_BUNDLES = new String[]{"org.eclipse.ecf.identity", "org.eclipse.ecf", "org.eclipse.ecf.discovery", "org.eclipse.ecf.remoteservice", "org.eclipse.ecf.remoteservice.asyncproxy", "org.eclipse.osgi.services.remoteserviceadmin"};
    }

    static void startDependents(BundleContext context, String[] bundleSymbolicNames, int stateMask) throws BundleException {
        List<String> bsns = Arrays.asList(bundleSymbolicNames);
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (bsns.contains(b.getSymbolicName()) && (b.getState() & stateMask) != 0) {
                b.start();
            }
            ++n2;
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public static Activator getDefault() {
        return instance;
    }

    public IContainerManager getContainerManager() {
        return (IContainerManager)ContainerFactory.getDefault();
    }

    private void initializeProxyServiceFactoryBundle() throws Exception {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (RSA_PROXY_BUNDLE_SYMBOLIC_ID.equals(b.getSymbolicName())) {
                b.start();
                this.proxyServiceFactoryBundleContext = b.getBundleContext();
            }
            ++n2;
        }
        if (this.proxyServiceFactoryBundleContext == null) {
            throw new IllegalStateException("RSA Proxy bundle (symbolic id=='org.eclipse.ecf.osgi.services.remoteserviceadmin.proxy') cannot be found, so RSA cannot be started");
        }
    }

    private void initializeProviders(Bundle hostBundle, String namespace, String startErrorMessage) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Bundle b = bundleArray[n2];
            BundleRevision rb = AccessController.doPrivileged(new PrivilegedAction<BundleRevision>(){

                @Override
                public BundleRevision run() {
                    return (BundleRevision)b.adapt(BundleRevision.class);
                }
            });
            List capabilities = rb.getCapabilities(namespace);
            int bundleTypes = rb.getTypes();
            if (capabilities != null && capabilities.size() > 0 && !b.getSymbolicName().equals(hostBundle.getSymbolicName()) && (bundleTypes & 1) == 0) {
                try {
                    b.start();
                }
                catch (BundleException e) {
                    LogUtility.logError("RemoteServiceAdmin.initializeProviders", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", Activator.class, String.valueOf(startErrorMessage) + " bundle=" + b.getSymbolicName(), e);
                }
            }
            ++n2;
        }
    }

    private void stopProxyServiceFactoryBundle() {
        if (this.proxyServiceFactoryBundleContext != null) {
            try {
                this.proxyServiceFactoryBundleContext.getBundle().stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proxyServiceFactoryBundleContext = null;
        }
    }

    public BundleContext getProxyServiceFactoryBundleContext(EndpointDescription endpointDescription) {
        return this.proxyServiceFactoryBundleContext;
    }

    private void removeSupportedConfigsAndIntents(ContainerTypeDescription ctd) {
        String[] descSupportedConfigs;
        String[] remoteConfigsSupported = (String[])this.rsaProps.get("remote.configs.supported");
        ArrayList<String> rcs = new ArrayList<String>();
        if (remoteConfigsSupported != null) {
            int i = 0;
            while (i < remoteConfigsSupported.length) {
                rcs.add(remoteConfigsSupported[i]);
                ++i;
            }
        }
        String[] remoteIntentsSupported = (String[])this.rsaProps.get("remote.intents.supported");
        ArrayList<String> ris = new ArrayList<String>();
        if (remoteIntentsSupported != null) {
            int i = 0;
            while (i < remoteIntentsSupported.length) {
                ris.add(remoteIntentsSupported[i]);
                ++i;
            }
        }
        if ((descSupportedConfigs = ctd.getSupportedConfigs()) != null) {
            int j = 0;
            while (j < descSupportedConfigs.length) {
                rcs.remove(descSupportedConfigs[j]);
                ++j;
            }
            String[] descSupportedIntents = ctd.getSupportedIntents();
            int j2 = 0;
            while (j2 < descSupportedIntents.length) {
                ris.remove(descSupportedIntents[j2]);
                ++j2;
            }
        }
        this.rsaProps.put("remote.configs.supported", rcs.toArray(new String[rcs.size()]));
        this.rsaProps.put("remote.intents.supported", ris.toArray(new String[ris.size()]));
    }

    void addSupportedConfigsAndIntents(ContainerTypeDescription desc) {
        String[] descSupportedConfigs;
        String[] remoteConfigsSupported = (String[])this.rsaProps.get("remote.configs.supported");
        ArrayList<String> rcs = new ArrayList<String>();
        if (remoteConfigsSupported != null) {
            int i = 0;
            while (i < remoteConfigsSupported.length) {
                rcs.add(remoteConfigsSupported[i]);
                ++i;
            }
        }
        String[] remoteIntentsSupported = (String[])this.rsaProps.get("remote.intents.supported");
        ArrayList<String> ris = new ArrayList<String>();
        if (remoteIntentsSupported != null) {
            int i = 0;
            while (i < remoteIntentsSupported.length) {
                ris.add(remoteIntentsSupported[i]);
                ++i;
            }
        }
        if ((descSupportedConfigs = desc.getSupportedConfigs()) != null) {
            int j = 0;
            while (j < descSupportedConfigs.length) {
                if (!rcs.contains(descSupportedConfigs[j])) {
                    rcs.add(descSupportedConfigs[j]);
                }
                ++j;
            }
            String[] descSupportedIntents = desc.getSupportedIntents();
            int j2 = 0;
            while (j2 < descSupportedIntents.length) {
                if (!ris.contains(descSupportedIntents[j2])) {
                    ris.add(descSupportedIntents[j2]);
                }
                ++j2;
            }
        }
        this.rsaProps.put("remote.configs.supported", rcs.toArray(new String[rcs.size()]));
        this.rsaProps.put("remote.intents.supported", ris.toArray(new String[ris.size()]));
    }

    private void initializeDependents() {
        try {
            Activator.startDependents(context, DEPENDENT_BUNDLES, 12);
        }
        catch (BundleException e) {
            LogUtility.logError("RemoteServiceAdmin.initializeDependents", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/remoteserviceadmin", this.getClass(), "Cannot start RSA dependent bundle", e);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
        this.exportedRegistrations = new ArrayList<ExportRegistration>();
        this.importedRegistrations = new ArrayList<ImportRegistration>();
        this.initializeDependents();
        this.initializeProxyServiceFactoryBundle();
        this.initializeProviders(context.getBundle(), "osgi.remoteserviceadmin.distribution", "Could not start distribution provider. ");
        this.rsaProps = new Properties();
        this.rsaProps.put("org.eclipse.ecf.rsa", new Boolean(true));
        this.remoteServiceAdminRegistration = context.registerService(RemoteServiceAdmin.class.getName(), (Object)new ServiceFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getService(Bundle bundle, ServiceRegistration registration) {
                org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin result = null;
                Map<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> map = Activator.this.remoteServiceAdmins;
                synchronized (map) {
                    result = Activator.this.remoteServiceAdmins.get(bundle);
                    if (result == null) {
                        result = new org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin(bundle, Activator.this.exportedRegistrations, Activator.this.importedRegistrations);
                        Activator.this.remoteServiceAdmins.put(bundle, result);
                    }
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                Map<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> map = Activator.this.remoteServiceAdmins;
                synchronized (map) {
                    org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin rsa = Activator.this.remoteServiceAdmins.remove(bundle);
                    if (rsa != null) {
                        rsa.close();
                    }
                }
            }
        }, this.rsaProps);
        this.ctdTracker = new ServiceTracker(context, ContainerTypeDescription.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ContainerTypeDescription, ContainerTypeDescription>(){

            public ContainerTypeDescription addingService(ServiceReference<ContainerTypeDescription> reference) {
                ContainerTypeDescription ctd = null;
                if (reference != null && context != null && (ctd = (ContainerTypeDescription)context.getService(reference)) != null) {
                    Activator.this.addSupportedConfigsAndIntents(ctd);
                    if (Activator.this.remoteServiceAdminRegistration != null) {
                        Activator.this.remoteServiceAdminRegistration.setProperties(Activator.this.rsaProps);
                    }
                }
                return ctd;
            }

            public void modifiedService(ServiceReference<ContainerTypeDescription> reference, ContainerTypeDescription service) {
            }

            public void removedService(ServiceReference<ContainerTypeDescription> reference, ContainerTypeDescription service) {
                if (Activator.this.remoteServiceAdminRegistration != null && service != null) {
                    Activator.this.removeSupportedConfigsAndIntents(service);
                    Activator.this.remoteServiceAdminRegistration.setProperties(Activator.this.rsaProps);
                }
            }
        });
        this.ctdTracker.open();
        this.endpointDescriptionLocator = new EndpointDescriptionLocator(context);
        Properties properties = new Properties();
        properties.put("service.ranking", (Object)Integer.MIN_VALUE);
        this.iServiceInfoFactoryRegistration = context.registerService(IServiceInfoFactory.class.getName(), (Object)new ServiceInfoFactory(), (Dictionary)properties);
        this.endpointDescriptionLocator.start();
        this.initializeProviders(context.getBundle(), "osgi.remoteserviceadmin.discovery", "Could not start discovery provider. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.endpointDescriptionLocator != null) {
            this.endpointDescriptionLocator.close();
            this.endpointDescriptionLocator = null;
        }
        if (this.ctdTracker != null) {
            this.ctdTracker.close();
            this.ctdTracker = null;
        }
        if (this.remoteServiceAdminRegistration != null) {
            this.remoteServiceAdminRegistration.unregister();
            this.remoteServiceAdminRegistration = null;
        }
        if (this.iServiceInfoFactoryRegistration != null) {
            this.iServiceInfoFactoryRegistration.unregister();
            this.iServiceInfoFactoryRegistration = null;
        }
        Collection<ImportRegistration> collection = this.saxParserFactoryTrackerLock;
        synchronized (collection) {
            if (this.saxParserFactoryTracker != null) {
                this.saxParserFactoryTracker.close();
                this.saxParserFactoryTracker = null;
            }
        }
        collection = this.logServiceTrackerLock;
        synchronized (collection) {
            if (this.logServiceTracker != null) {
                this.logServiceTracker.close();
                this.logServiceTracker = null;
                this.logService = null;
            }
        }
        this.stopProxyServiceFactoryBundle();
        collection = this.importedRegistrations;
        synchronized (collection) {
            if (this.importedRegistrations != null) {
                this.importedRegistrations.clear();
                this.importedRegistrations = null;
            }
        }
        collection = this.exportedRegistrations;
        synchronized (collection) {
            if (this.exportedRegistrations != null) {
                this.exportedRegistrations.clear();
                this.exportedRegistrations = null;
            }
        }
        context = null;
        instance = null;
    }

    public boolean isOldEquinox() {
        if (context == null) {
            return false;
        }
        Bundle systemBundle = context.getBundle(0L);
        String systemBSN = systemBundle.getSymbolicName();
        if ("org.eclipse.osgi".equals(systemBSN)) {
            Version fixedVersion = new Version("3.7.0");
            Version systemVersion = systemBundle.getVersion();
            if (systemVersion.compareTo(fixedVersion) < 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFrameworkUUID() {
        if (context == null) {
            return null;
        }
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String result = context.getProperty("org.osgi.framework.uuid");
            if (result == null) {
                UUID newUUID = UUID.randomUUID();
                result = newUUID.toString();
                System.setProperty("org.osgi.framework.uuid", newUUID.toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAXParserFactory getSAXParserFactory() {
        if (instance == null) {
            return null;
        }
        Object object = this.saxParserFactoryTrackerLock;
        synchronized (object) {
            SAXParserFactory result;
            if (this.saxParserFactoryTracker == null) {
                this.saxParserFactoryTracker = new ServiceTracker(context, SAXParserFactory.class.getName(), null);
                this.saxParserFactoryTracker.open();
            }
            if ((result = (SAXParserFactory)this.saxParserFactoryTracker.getService()) == null) {
                result = SAXParserFactory.newInstance();
                context.registerService(SAXParserFactory.class.getName(), (Object)result, null);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogService getLogService() {
        if (context == null) {
            return null;
        }
        Object object = this.logServiceTrackerLock;
        synchronized (object) {
            if (this.logServiceTracker == null) {
                this.logServiceTracker = new ServiceTracker(context, LogService.class.getName(), null);
                this.logServiceTracker.open();
            }
            this.logService = (LogService)this.logServiceTracker.getService();
            if (this.logService == null) {
                this.logService = new SystemLogService(PLUGIN_ID);
            }
            return this.logService;
        }
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }
}

