/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.presence;

import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.presence.RosterManager;
import org.eclipse.ecf.presence.AbstractPresenceContainer;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceSender;
import org.eclipse.ecf.presence.history.IHistoryManager;
import org.eclipse.ecf.presence.im.IChat;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.search.IUserSearchManager;
import org.eclipse.ecf.presence.search.message.IMessageSearchManager;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PresenceContainer
extends AbstractPresenceContainer
implements IChatManager,
IChatMessageSender,
IPresenceSender,
IPresenceService {
    private final ListenerList messageListeners = new ListenerList();
    private final EclipseCollabSharedObject sharedObject;
    private final IContainer container;
    private final IRosterManager manager;
    private ServiceRegistration serviceRegistration;

    public PresenceContainer(EclipseCollabSharedObject sharedObject, IContainer container, IUser user) {
        this.sharedObject = sharedObject;
        this.container = container;
        this.manager = new RosterManager(this, user);
        BundleContext bundleContext = ClientPlugin.getDefault().getBundle().getBundleContext();
        this.serviceRegistration = bundleContext.registerService(IPresenceService.class.getName(), (Object)this, null);
    }

    public void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public IChatManager getChatManager() {
        return this;
    }

    public IRosterManager getRosterManager() {
        return this.manager;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        if (adapter == IContainer.class) {
            return this.container;
        }
        return super.getAdapter(adapter);
    }

    public void fireMessageEvent(IIMMessageEvent messageEvent) {
        Object[] listeners = this.messageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IIMMessageListener listener = (IIMMessageListener)listeners[i];
            listener.handleMessageEvent(messageEvent);
            ++i;
        }
    }

    public void addMessageListener(IIMMessageListener listener) {
        this.messageListeners.add((Object)listener);
    }

    public void removeMessageListener(IIMMessageListener listener) {
        this.messageListeners.remove((Object)listener);
    }

    public void sendPresenceUpdate(ID targetId, IPresence presence) throws ECFException {
    }

    public IChat createChat(ID targetUser, IIMMessageListener messageListener) throws ECFException {
        return null;
    }

    public IChatMessageSender getChatMessageSender() {
        return this;
    }

    public IHistoryManager getHistoryManager() {
        return null;
    }

    public ITypingMessageSender getTypingMessageSender() {
        return null;
    }

    public void sendChatMessage(ID toId, ID threadId, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
        this.sharedObject.sendPrivateMessageToUser(toId, body);
    }

    public void sendChatMessage(ID toId, String body) throws ECFException {
        this.sendChatMessage(toId, null, null, null, body, null);
    }

    public IUserSearchManager getUserSearchManager() {
        return null;
    }

    public IMessageSearchManager getMessageSearchManager() {
        return null;
    }
}

