/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.screencapture;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.ui.screencapture.ImageWrapper;
import org.eclipse.ecf.ui.screencapture.ScreenCaptureUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowImageShell {
    Shell shell;
    ID senderID;
    ImageWrapper imageWrapper;
    Image image;
    List imageData;

    public ShowImageShell(Display display, ID senderID, final DisposeListener disposeListener) {
        this.shell = new Shell(display);
        this.senderID = senderID;
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                disposeListener.widgetDisposed(e);
                ShowImageShell.this.senderID = null;
                ShowImageShell.this.imageWrapper = null;
                ShowImageShell.this.imageData = null;
                if (ShowImageShell.this.image != null) {
                    ShowImageShell.this.image.dispose();
                    ShowImageShell.this.image = null;
                }
            }
        });
    }

    public void initialize(String text, ImageWrapper iw) {
        if (this.shell != null) {
            this.shell.setText(text);
            this.imageWrapper = iw;
            Rectangle shellBounds = this.shell.getBounds();
            this.shell.setBounds(this.shell.computeTrim(shellBounds.x, shellBounds.y, this.imageWrapper.width, this.imageWrapper.height));
            this.imageData = new ArrayList();
        }
    }

    public void open() {
        if (this.shell != null) {
            this.shell.open();
        }
    }

    public Display getDisplay() {
        if (this.shell == null) {
            return null;
        }
        return this.shell.getDisplay();
    }

    public void close() {
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!ShowImageShell.this.shell.isDisposed()) {
                            ShowImageShell.this.shell.close();
                        }
                        ShowImageShell.this.shell = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public ID getSenderID() {
        return this.senderID;
    }

    public void addData(byte[] bytes) {
        this.imageData.add(bytes);
    }

    public void showImage() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (this.imageData != null) {
                Iterator i = this.imageData.iterator();
                while (i.hasNext()) {
                    bos.write((byte[])i.next());
                }
            }
            bos.flush();
        }
        catch (IOException i) {
            // empty catch block
        }
        this.imageData.clear();
        final byte[] uncompressedData = ScreenCaptureUtil.uncompress(bos.toByteArray());
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ShowImageShell.this.image = new Image((Device)ShowImageShell.this.shell.getDisplay(), ShowImageShell.this.imageWrapper.createImageData(uncompressedData));
                ShowImageShell.this.shell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.drawImage((this).ShowImageShell.this.image, 0, 0);
                    }
                });
                ShowImageShell.this.shell.redraw();
            }
        });
    }
}

