/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.filetransfer;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.util.LogHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.filetransfer";
    private static final String URLCONNECTION_FACTORY_EPOINT = "org.eclipse.ecf.filetransfer.urlStreamHandlerService";
    private static final String PROTOCOL_ATTRIBUTE = "protocol";
    private static final String SERVICE_CLASS_ATTRIBUTE = "serviceClass";
    private ServiceTracker extensionRegistryTracker = null;
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        plugin = this;
        this.setupProtocolHandlers(ctxt);
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistryTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extensionRegistryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    private void setupProtocolHandlers(BundleContext context) {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(URLCONNECTION_FACTORY_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configurationElements.length) {
                AbstractURLStreamHandlerService svc = null;
                String protocol = null;
                try {
                    svc = (AbstractURLStreamHandlerService)configurationElements[i].createExecutableExtension(SERVICE_CLASS_ATTRIBUTE);
                    protocol = configurationElements[i].getAttribute(PROTOCOL_ATTRIBUTE);
                }
                catch (CoreException e) {
                    this.log(e.getStatus());
                }
                if (svc != null && protocol != null) {
                    Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
                    properties.put("url.handler.protocol", new String[]{protocol});
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.osgi.service.url.URLStreamHandlerService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    context.registerService(clazz.getName(), (Object)svc, properties);
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }
}

