/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.collab.ui.url;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.internal.presence.collab.ui.Messages;
import org.eclipse.ecf.presence.collab.ui.AbstractCollabShare;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class URLShare
extends AbstractCollabShare {
    private static final Hashtable urlsharechannels = new Hashtable();

    public static URLShare getURLShare(ID containerID) {
        return (URLShare)((Object)urlsharechannels.get(containerID));
    }

    public static URLShare addURLShare(ID containerID, IChannelContainerAdapter channelAdapter) throws ECFException {
        return urlsharechannels.put(containerID, new URLShare(channelAdapter));
    }

    public static URLShare removeURLShare(ID containerID) {
        return (URLShare)((Object)urlsharechannels.remove(containerID));
    }

    public URLShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    private void showURL(final String user, final String url) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (MessageDialog.openQuestion(null, (String)Messages.URLShare_RECEIVED_URL_TITLE, (String)NLS.bind((String)Messages.URLShare_RECEIVED_URL_MESSAGE, (Object)user, (Object)url))) {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        IWebBrowser browser = support.createBrowser(null);
                        browser.openURL(new URL(url));
                    }
                    catch (Exception e) {
                        URLShare.this.logError(Messages.URLShare_EXCEPTION_LOG_BROWSER, e);
                    }
                }
            }
        });
    }

    public void sendURL(String senderuser, ID toID, String theURL) {
        try {
            this.sendMessage(toID, this.serialize(new Object[]{senderuser, theURL}));
        }
        catch (ECFException e) {
            this.logError(e.getStatus());
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_SEND, e);
        }
    }

    public void showDialogAndSendURL(final String senderuser, final ID toID) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String send;
                InputDialog input = new InputDialog(null, Messages.URLShare_INPUT_URL_DIALOG_TITLE, Messages.URLShare_ENTER_URL_DIALOG_TEXT, Messages.URLShare_ENTER_URL_DEFAULT_URL, null);
                input.setBlockOnOpen(true);
                int result = input.open();
                if (result == 0 && (send = input.getValue()) != null && !send.equals("")) {
                    try {
                        URLShare.this.sendMessage(toID, URLShare.this.serialize(new Object[]{senderuser, send}));
                    }
                    catch (ECFException e) {
                        URLShare.this.logError(e.getStatus());
                    }
                    catch (Exception e) {
                        URLShare.this.logError(Messages.Share_EXCEPTION_LOG_SEND, e);
                    }
                }
            }
        });
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        try {
            Object[] msg = (Object[])this.deserialize(data);
            this.showURL((String)msg[0], (String)msg[1]);
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_MESSAGE, e);
        }
    }
}

