/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.ui.wizards;

import java.net.URI;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.provider.ui.wizards.GenericClientContainerConnectWizardPage;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.wizards.AbstractConnectWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public class GenericClientContainerConnectWizard
extends Wizard
implements IConnectWizard {
    protected static final int CONNECT_ERROR_CODE = 7777;
    private IContainer container;
    private AbstractConnectWizardPage wizardPage;
    private ID targetID;
    private IConnectContext connectContext;
    private URI uri;

    public GenericClientContainerConnectWizard() {
    }

    public GenericClientContainerConnectWizard(URI uri) {
        this.uri = uri;
    }

    public void addPages() {
        this.wizardPage = new GenericClientContainerConnectWizardPage(this.uri);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.container = container;
    }

    public ID getTargetID() {
        return this.targetID;
    }

    public IConnectContext getConnectContext() {
        return this.connectContext;
    }

    public boolean performFinish() {
        if (this.wizardPage.shouldRequestPassword()) {
            String password = this.wizardPage.getPassword();
            this.connectContext = this.wizardPage.shouldRequestUsername() ? ConnectContextFactory.createUsernamePasswordConnectContext((String)this.wizardPage.getUsername(), (Object)password) : ConnectContextFactory.createPasswordConnectContext((String)password);
        }
        try {
            this.targetID = IDFactory.getDefault().createID(this.container.getConnectNamespace(), this.wizardPage.getConnectID());
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, this.wizardPage.getConnectID(), e).open();
            return false;
        }
        new AsynchContainerConnectAction(this.container, this.targetID, this.connectContext).run();
        return true;
    }
}

