/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.XMLSerializer;

public class JSONSerializer
extends XMLSerializer {
    @Override
    public byte[] serialize(Object object, Session session) {
        try {
            if (this.context == null) {
                String packageName = object.getClass().getPackage().getName();
                this.context = JAXBContext.newInstance((String)packageName);
            }
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)stream);
            return stream.toByteArray();
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Session session) {
        try {
            if (this.context == null) {
                String packageName = session.getDescriptors().keySet().iterator().next().getPackage().getName();
                this.context = JAXBContext.newInstance((String)packageName);
            }
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            return unmarshaller.unmarshal((InputStream)stream);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

