/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import _dbws.ProviderListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.internal.dbws.ProviderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.InMemoryCompiler;
import org.eclipse.persistence.tools.dbws.WarArchiver;
import org.eclipse.persistence.tools.dbws.XRPackager;

public class ProviderPackager
extends XRPackager {
    public static final String PROVIDER_NAME = "_dbws.DBWSProvider";
    public static final String PROVIDER_LISTENER_SOURCE = "package _dbws;\n\nimport javax.servlet.ServletContext;\nimport javax.servlet.ServletContextEvent;\nimport javax.servlet.ServletContextListener;\n\npublic class ProviderListener implements ServletContextListener {\n\n    public static ServletContext SC = null;\n\n    public  ProviderListener() {\n        super();\n    }\n\n    public void contextInitialized(ServletContextEvent sce) {\n        SC = sce.getServletContext();\n    }\n\n    public void contextDestroyed(ServletContextEvent sce) {\n        // no-op\n    }\n}\n";
    public static final String DBWS_PROVIDER_SOURCE_PREAMBLE_START = "package _dbws;\n\n//Java extension libraries\nimport javax.annotation.PostConstruct;\nimport javax.annotation.PreDestroy;\nimport javax.annotation.Resource;\nimport javax.servlet.ServletContext;\nimport javax.xml.soap.SOAPMessage;\nimport javax.xml.ws.BindingType;\nimport javax.xml.ws.Provider;\nimport javax.xml.ws.ServiceMode;\nimport javax.xml.ws.WebServiceContext;\nimport javax.xml.ws.WebServiceProvider;\nimport static javax.xml.ws.Service.Mode.MESSAGE;\n";
    public static final String DBWS_PROVIDER_SOURCE_SOAP11HTTP_MTOM_BINDING = "import static javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_MTOM_BINDING;\n";
    public static final String DBWS_PROVIDER_SOURCE_SOAP12HTTP_BINDING = "import static javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING;\n";
    public static final String DBWS_PROVIDER_SOURCE_SOAP12HTTP_MTOM_BINDING = "import static javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_MTOM_BINDING;\n";
    public static final String DBWS_PROVIDER_SOURCE_PREAMBLE_END = "\n//EclipseLink imports\nimport " + ProviderHelper.class.getName() + ";\n" + "\n@WebServiceProvider(\n";
    public static final String DBWS_PROVIDER_SOURCE_WSDL_LOCATION = "    wsdlLocation = \"WEB-INF/wsdl/eclipselink-dbws.wsdl\",\n";
    public static final String DBWS_PROVIDER_SOURCE_SERVICE_NAME = "    serviceName = \"";
    public static final String DBWS_PROVIDER_SOURCE_PORT_NAME = "\",\n    portName = \"";
    public static final String DBWS_PROVIDER_SOURCE_TARGET_NAMESPACE = "\",\n    targetNamespace = \"";
    public static final String DBWS_PROVIDER_SOURCE_SUFFIX = "\"\n)\n@ServiceMode(MESSAGE)\n";
    public static final String DBWS_PROVIDER_SOAP12_BINDING = "@BindingType(value=SOAP12HTTP_BINDING)\n";
    public static final String DBWS_PROVIDER_SOAP11_MTOM_BINDING = "@BindingType(value=SOAP11HTTP_MTOM_BINDING)\n";
    public static final String DBWS_PROVIDER_SOAP12_MTOM_BINDING = "@BindingType(value=SOAP12HTTP_MTOM_BINDING)\n";
    public static final String DBWS_PROVIDER_SOURCE_CLASSDEF = "public class DBWSProvider extends ProviderHelper implements Provider<SOAPMessage> {\n\n    // Container injects wsContext here\n    @Resource\n    protected WebServiceContext wsContext;\n\n    public  DBWSProvider() {\n        super();\n    }\n\n    @PostConstruct\n    public void init() {\n        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();\n        ServletContext sc = ProviderListener.SC;\n        boolean mtomEnabled = false;\n        BindingType thisBindingType = this.getClass().getAnnotation(BindingType.class);\n        if (thisBindingType != null) {\n            if (thisBindingType.value().toLowerCase().contains(\"mtom=true\")) {\n                mtomEnabled = true;\n            }\n        }\n        super.init(parentClassLoader, sc, mtomEnabled);\n    }\n\n    @Override\n    public SOAPMessage invoke(SOAPMessage request) {\n        if (wsContext != null) {\n            setMessageContext(wsContext.getMessageContext());\n        }\n        return super.invoke(request);\n    }\n\n    @Override\n    @PreDestroy\n    public void destroy() {\n        super.destroy();\n    }\n};\n";
    static final int DEFAULT_BUFFER_SIZE = 4096;

    public ProviderPackager() {
        this(new WarArchiver(), "provider", DBWSPackager.ArchiveUse.noArchive);
    }

    protected ProviderPackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return new WarArchiver(this);
    }

    @Override
    public OutputStream getWSDLStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws.wsdl"));
    }

    @Override
    public OutputStream getProviderClassStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "DBWSProvider.class"));
    }

    @Override
    public OutputStream getProviderSourceStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "DBWSProvider.java"));
    }

    @Override
    public OutputStream getProviderListenerSourceStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "ProviderListener.java"));
    }

    @Override
    public OutputStream getProviderListenerClassStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "ProviderListener.class"));
    }

    @Override
    public void writeProvider(OutputStream sourceProviderStream, OutputStream classProviderStream, OutputStream sourceProviderListenerStream, OutputStream classProviderListenerStream, DBWSBuilder builder) {
        OutputStreamWriter osw;
        StringBuilder source = new StringBuilder(DBWS_PROVIDER_SOURCE_PREAMBLE_START);
        if (builder.usesSOAP12()) {
            if (builder.mtomEnabled()) {
                source.append(DBWS_PROVIDER_SOURCE_SOAP12HTTP_MTOM_BINDING);
            } else {
                source.append(DBWS_PROVIDER_SOURCE_SOAP12HTTP_BINDING);
            }
        } else if (builder.mtomEnabled()) {
            source.append(DBWS_PROVIDER_SOURCE_SOAP11HTTP_MTOM_BINDING);
        }
        source.append((CharSequence)new StringBuilder(DBWS_PROVIDER_SOURCE_PREAMBLE_END));
        String wsdlPathPrevix = this.getWSDLPathPrefix();
        if (wsdlPathPrevix != null) {
            source.append(DBWS_PROVIDER_SOURCE_WSDL_LOCATION);
        }
        source.append(DBWS_PROVIDER_SOURCE_SERVICE_NAME);
        String serviceName = builder.getWSDLGenerator().getServiceName();
        source.append(serviceName);
        source.append(DBWS_PROVIDER_SOURCE_PORT_NAME);
        source.append(String.valueOf(serviceName) + "Port");
        source.append(DBWS_PROVIDER_SOURCE_TARGET_NAMESPACE);
        source.append(builder.getWSDLGenerator().getServiceNameSpace());
        source.append(DBWS_PROVIDER_SOURCE_SUFFIX);
        if (builder.usesSOAP12()) {
            if (builder.mtomEnabled()) {
                source.append(DBWS_PROVIDER_SOAP12_MTOM_BINDING);
            } else {
                source.append(DBWS_PROVIDER_SOAP12_BINDING);
            }
        } else if (builder.mtomEnabled()) {
            source.append(DBWS_PROVIDER_SOAP11_MTOM_BINDING);
        }
        source.append(DBWS_PROVIDER_SOURCE_CLASSDEF);
        if (sourceProviderStream != __nullStream) {
            osw = new OutputStreamWriter(new BufferedOutputStream(sourceProviderStream));
            try {
                osw.write(source.toString());
                osw.flush();
            }
            catch (IOException iOException) {}
        }
        if (classProviderStream != __nullStream) {
            InMemoryCompiler providerCompiler = new InMemoryCompiler(PROVIDER_NAME);
            if (providerCompiler.getCompiler() == null) {
                throw new IllegalStateException("DBWSBuilder cannot compile DBWSProvider code\nPlease ensure that tools.jar is on your classpath");
            }
            byte[] bytes = providerCompiler.compile(source);
            if (bytes.length == 0) {
                DiagnosticCollector<JavaFileObject> collector = providerCompiler.getDiagnosticsCollector();
                StringBuilder diagBuf = new StringBuilder("DBWSBuilder cannot generate ProviderListener code (likely servlet jar missing from classpath)\n");
                for (Diagnostic<JavaFileObject> d : collector.getDiagnostics()) {
                    if (d.getKind() != Diagnostic.Kind.ERROR) continue;
                    diagBuf.append(d.getMessage(null));
                    diagBuf.append("\n");
                }
                throw new IllegalStateException(diagBuf.toString());
            }
            try {
                classProviderStream.write(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sourceProviderListenerStream != __nullStream) {
            osw = new OutputStreamWriter(new BufferedOutputStream(sourceProviderListenerStream));
            try {
                osw.write(PROVIDER_LISTENER_SOURCE);
                osw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (classProviderListenerStream != __nullStream) {
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(ProviderListener.class.getName().replace('.', '/')) + ".class");
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = is.read(buffer))) {
                    classProviderListenerStream.write(buffer, 0, n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

