/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.Helper;

public class JavaPlatform {
    private static final ConcurrentHashMap patternCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap regexpPatternCache = new ConcurrentHashMap();

    public static Boolean conformLike(Object left, Object right) {
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = (Pattern)patternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            String convertedRight = Helper.convertLikeToRegex((String)right);
            pattern = Pattern.compile(convertedRight);
            if (patternCache.size() > 100) {
                patternCache.remove(patternCache.keySet().iterator().next());
            }
            patternCache.put(right, pattern);
        }
        return pattern.matcher((String)left).matches();
    }

    public static Boolean conformRegexp(Object left, Object right) {
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = (Pattern)regexpPatternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            pattern = Pattern.compile((String)right);
            if (regexpPatternCache.size() > 100) {
                regexpPatternCache.remove(regexpPatternCache.keySet().iterator().next());
            }
            regexpPatternCache.put(right, pattern);
        }
        return pattern.matcher((String)left).matches();
    }

    public static boolean isSQLXML(Object object) {
        return object instanceof SQLXML;
    }

    public static String getStringAndFreeSQLXML(Object sqlXml) throws SQLException {
        String str = ((SQLXML)sqlXml).getString();
        ((SQLXML)sqlXml).free();
        return str;
    }
}

