/**
 * Copyright 2008 Atlassian Pty Ltd 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */

package org.bson.util;

/**
 * Design by contract assertions.
 */
public class Assertions {
    public static <T> T notNull(final String name, final T notNull) throws IllegalArgumentException {
        if (notNull == null) {
            throw new NullArgumentException(name);
        }
        return notNull;
    }

    public static void isTrue(final String name, final boolean check) throws IllegalArgumentException {
        if (!check) {
            throw new IllegalArgumentException(name);
        }
    }

    // /CLOVER:OFF
    private Assertions() {}

    // /CLOVER:ON

    static class NullArgumentException extends IllegalArgumentException {
        private static final long serialVersionUID = 6178592463723624585L;

        NullArgumentException(final String name) {
            super(name + " should not be null!");
        }
    }
}
