/*******************************************************************************
 * Copyright (c) 2011, 2015 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.jpa.jpql.parser;

/**
 * This {@link ExpressionVisitor} traverses the entire hierarchy of the JPQL parsed tree by going
 * down into each of the children of any given {@link Expression}. It is up to the subclass to
 * complete the behavior.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.5
 * @since 2.4
 * @author Pascal Filion
 */
public abstract class AbstractEclipseLinkTraverseChildrenVisitor extends AbstractTraverseChildrenVisitor
                                                                 implements EclipseLinkExpressionVisitor {

    /**
     * {@inheritDoc}
     */
    public void visit(AsOfClause expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(CastExpression expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(ConnectByClause expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(DatabaseType expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(ExtractExpression expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(HierarchicalQueryClause expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(OrderSiblingsByClause expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(RegexpExpression expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(StartWithClause expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(TableExpression expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(TableVariableDeclaration expression) {
        visit((Expression) expression);
    }

    /**
     * {@inheritDoc}
     */
    public void visit(UnionClause expression) {
        visit((Expression) expression);
    }
}
