/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.CodeSetsComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.ee.spi.servicecontext.MaxStreamFormatVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.ServiceContextsCache;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.servicecontext.UnknownServiceContext;
import com.sun.corba.ee.spi.trace.Subcontract;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.ContactInfoListIterator;
import com.sun.corba.ee.spi.transport.OutboundConnectionCache;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.UnknownException;

@Subcontract
public class ClientRequestDispatcherImpl
implements ClientRequestDispatcher {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private final Object lock = new Object();
    private ORBVersionServiceContext ovsc = ServiceContextDefaults.makeORBVersionServiceContext();
    private MaxStreamFormatVersionServiceContext msfvc = ServiceContextDefaults.getMaxStreamFormatVersionServiceContext();
    private ConcurrentMap<ContactInfo, Object> locks = new ConcurrentHashMap<ContactInfo, Object>();

    @InfoMethod
    private void usingCachedConnection(Connection conn) {
    }

    @InfoMethod
    private void usingCreatedConnection(Connection conn) {
    }

    @InfoMethod
    private void connectionCached(Connection conn) {
    }

    @InfoMethod
    private void connectionRegistered(Connection conn) {
    }

    @InfoMethod
    private void createdMessageMediator(MessageMediator med) {
    }

    @InfoMethod
    private void createOutputObject(CDROutputObject out) {
    }

    @InfoMethod
    private void generalMessage(String msg) {
    }

    @InfoMethod
    private void remarshalWithHasNextTrue(ContactInfo info) {
    }

    @InfoMethod(tpName="totalRequest", tpType=TimingPointType.ENTER)
    private void enter_totalRequest() {
    }

    @InfoMethod(tpName="totalRequest", tpType=TimingPointType.EXIT)
    private void exit_totalRequest() {
    }

    @InfoMethod(tpName="connectionSetup", tpType=TimingPointType.ENTER)
    private void enter_connectionSetup() {
    }

    @InfoMethod(tpName="connectionSetup", tpType=TimingPointType.EXIT)
    private void exit_connectionSetup() {
    }

    @InfoMethod(tpName="clientDecoding", tpType=TimingPointType.ENTER)
    private void enter_clientDecoding() {
    }

    @InfoMethod(tpName="clientDecoding", tpType=TimingPointType.EXIT)
    private void exit_clientDecoding() {
    }

    @InfoMethod(tpName="clientEncoding", tpType=TimingPointType.ENTER)
    private void enter_clientEncoding() {
    }

    @InfoMethod(tpName="clientEncoding", tpType=TimingPointType.EXIT)
    private void exit_clientEncoding() {
    }

    @InfoMethod(tpName="clientTransportAndWait", tpType=TimingPointType.ENTER)
    private void enter_clientTransportAndWait() {
    }

    @InfoMethod(tpName="clientTransportAndWait", tpType=TimingPointType.EXIT)
    private void exit_clientTransportAndWait() {
    }

    @InfoMethod(tpName="processResponse", tpType=TimingPointType.ENTER)
    private void enter_processResponse() {
    }

    @InfoMethod(tpName="processResponse", tpType=TimingPointType.EXIT)
    private void exit_processResponse() {
    }

    @InfoMethod(tpName="requestAddServiceContexts", tpType=TimingPointType.ENTER)
    private void enter_requestAddServiceContexts() {
    }

    @InfoMethod(tpName="requestAddServiceContexts", tpType=TimingPointType.EXIT)
    private void exit_requestAddServiceContexts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Subcontract
    public CDROutputObject beginRequest(Object self, String opName, boolean isOneWay, ContactInfo contactInfo) {
        Object newLock;
        ORB orb = contactInfo.getBroker();
        this.enter_totalRequest();
        orb.getPIHandler().initiateClientPIRequest(false);
        Connection connection = null;
        Object lock = this.locks.get(contactInfo);
        if (lock == null && (lock = this.locks.putIfAbsent(contactInfo, newLock = new Object())) == null) {
            lock = newLock;
        }
        newLock = lock;
        synchronized (newLock) {
            if (contactInfo.isConnectionBased()) {
                try {
                    this.enter_connectionSetup();
                    if (contactInfo.shouldCacheConnection()) {
                        connection = orb.getTransportManager().getOutboundConnectionCache(contactInfo).get(contactInfo);
                    }
                    if (connection != null) {
                        this.usingCachedConnection(connection);
                    } else {
                        connection = contactInfo.createConnection();
                        this.usingCreatedConnection(connection);
                        if (connection.shouldRegisterReadEvent()) {
                            orb.getTransportManager().getSelector(0).registerForEvent(connection.getEventHandler());
                            connection.setState("ESTABLISHED");
                            this.connectionRegistered(connection);
                        }
                        if (contactInfo.shouldCacheConnection()) {
                            OutboundConnectionCache connectionCache = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                            connectionCache.stampTime(connection);
                            connectionCache.put(contactInfo, connection);
                            this.connectionCached(connection);
                        }
                    }
                }
                finally {
                    this.exit_connectionSetup();
                }
            }
        }
        MessageMediator messageMediator = contactInfo.createMessageMediator(orb, contactInfo, connection, opName, isOneWay);
        this.createdMessageMediator(messageMediator);
        orb.getInvocationInfo().setMessageMediator(messageMediator);
        this.performCodeSetNegotiation(messageMediator);
        this.enter_requestAddServiceContexts();
        try {
            this.addServiceContexts(messageMediator);
        }
        finally {
            this.exit_requestAddServiceContexts();
        }
        CDROutputObject outputObject = contactInfo.createOutputObject(messageMediator);
        this.createOutputObject(outputObject);
        this.registerWaiter(messageMediator);
        Object object = lock;
        synchronized (object) {
            if (contactInfo.isConnectionBased() && contactInfo.shouldCacheConnection()) {
                this.generalMessage("reclaiming connections");
                OutboundConnectionCache connectionCache = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                connectionCache.reclaim();
            }
        }
        orb.getPIHandler().setClientPIInfo(messageMediator);
        try {
            orb.getPIHandler().invokeClientPIStartingPoint();
        }
        catch (RemarshalException e) {
            this.generalMessage("Remarshal");
            if (this.getContactInfoListIterator(orb).hasNext()) {
                contactInfo = (ContactInfo)this.getContactInfoListIterator(orb).next();
                this.remarshalWithHasNextTrue(contactInfo);
                orb.getPIHandler().makeCompletedClientRequest(3, null);
                this.unregisterWaiter(orb);
                orb.getPIHandler().cleanupClientPIRequest();
                return this.beginRequest(self, opName, isOneWay, contactInfo);
            }
            this.retryMessage("RemarshalException: hasNext false");
            throw wrapper.remarshalWithNowhereToGo();
        }
        messageMediator.initializeMessage();
        this.generalMessage("initialized message");
        this.enter_clientEncoding();
        return outputObject;
    }

    @InfoMethod
    private void operationAndId(String op, int rid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Subcontract
    public CDRInputObject marshalingComplete(Object self, CDROutputObject outputObject) throws ApplicationException, RemarshalException {
        MessageMediator messageMediator = outputObject.getMessageMediator();
        ORB orb = messageMediator.getBroker();
        this.operationAndId(messageMediator.getOperationName(), messageMediator.getRequestId());
        try {
            this.exit_clientEncoding();
            this.enter_clientTransportAndWait();
            CDRInputObject inputObject = null;
            try {
                inputObject = this.marshalingComplete1(orb, messageMediator);
            }
            finally {
                this.exit_clientTransportAndWait();
            }
            CDRInputObject cDRInputObject = this.processResponse(orb, messageMediator, inputObject);
            return cDRInputObject;
        }
        finally {
            this.enter_clientDecoding();
        }
    }

    @InfoMethod
    private void retryMessage(String msg) {
    }

    @InfoMethod
    private void reportException(Throwable exc) {
    }

    @InfoMethod
    private void reportException(String msg, Throwable exc) {
    }

    @Subcontract
    public CDRInputObject marshalingComplete1(ORB orb, MessageMediator messageMediator) throws ApplicationException, RemarshalException {
        this.operationAndId(messageMediator.getOperationName(), messageMediator.getRequestId());
        try {
            messageMediator.finishSendingRequest();
            return messageMediator.waitForResponse();
        }
        catch (RuntimeException e) {
            this.reportException(e);
            boolean retry = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), e);
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(2, e);
            if (retry) {
                if (newException == e) {
                    this.retryMessage("Retry true; same exception");
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                } else {
                    this.retryMessage("Retry true; new exception");
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
            } else {
                if (newException instanceof RuntimeException) {
                    this.retryMessage("Retry false; RuntimeException");
                    throw (RuntimeException)newException;
                }
                if (newException instanceof RemarshalException) {
                    throw (RemarshalException)((Object)newException);
                }
                this.retryMessage("Retry false; other exception");
                throw e;
            }
            return null;
        }
    }

    @InfoMethod
    private void receivedUserException(String repoid) {
    }

    @InfoMethod
    private void receivedUserExceptionDII(Throwable exc, Throwable newExc) {
    }

    @InfoMethod
    private void receivedUserExceptionNotDII(Throwable exc, Throwable newExc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected CDRInputObject processResponse(ORB orb, MessageMediator messageMediator, CDRInputObject inputObject) throws ApplicationException, RemarshalException {
        this.operationAndId(messageMediator.getOperationName(), messageMediator.getRequestId());
        this.enter_processResponse();
        try {
            if (messageMediator.getConnection() != null) {
                this.generalMessage("Non-null connection");
                messageMediator.getConnection().setPostInitialContexts();
            }
            Exception exception = null;
            if (messageMediator.isOneWay()) {
                this.generalMessage("One way request");
                this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
                exception = orb.getPIHandler().invokeClientPIEndingPoint(0, exception);
                this.reportException(exception);
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                CDRInputObject cDRInputObject = null;
                return cDRInputObject;
            }
            this.consumeServiceContexts(orb, messageMediator);
            inputObject.performORBVersionSpecificInit();
            if (messageMediator.isSystemExceptionReply()) {
                UEInfoServiceContext usc;
                SystemException se = messageMediator.getSystemExceptionReply();
                this.reportException("received system exception", se);
                boolean doRemarshal = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), (RuntimeException)((Object)se));
                if (doRemarshal) {
                    this.reportException("Do remarshal", se);
                    exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
                    if (se == exception) {
                        this.generalMessage("Do remarshal: same exception");
                        exception = null;
                        this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                        throw wrapper.statementNotReachable1();
                    }
                    this.reportException("Do remarshal: new exception", exception);
                    this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                    throw wrapper.statementNotReachable2();
                }
                this.reportException("NO remarshal", se);
                ServiceContexts contexts = messageMediator.getReplyServiceContexts();
                if (contexts != null && (usc = (UEInfoServiceContext)contexts.get(9)) != null) {
                    Throwable unknown = usc.getUE();
                    UnknownException ue = new UnknownException(unknown);
                    this.reportException("NO remarshal: UserException available", unknown);
                    exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)ue);
                    this.reportException("NO remarshal: UserException available: PI exception ", exception);
                    this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                    throw wrapper.statementNotReachable3();
                }
                this.reportException("general exception", se);
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
                this.reportException("general exception: PI exception", exception);
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                throw wrapper.statementNotReachable4();
            }
            if (messageMediator.isUserExceptionReply()) {
                this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
                String exceptionRepoId = this.peekUserExceptionId(inputObject);
                this.receivedUserException(exceptionRepoId);
                Exception newException = null;
                if (messageMediator.isDIIRequest()) {
                    exception = messageMediator.unmarshalDIIUserException(exceptionRepoId, inputObject);
                    newException = orb.getPIHandler().invokeClientPIEndingPoint(1, exception);
                    messageMediator.setDIIException(newException);
                    this.receivedUserExceptionDII(exception, newException);
                } else {
                    ApplicationException appException = new ApplicationException(exceptionRepoId, (InputStream)inputObject);
                    exception = appException;
                    newException = orb.getPIHandler().invokeClientPIEndingPoint(1, (Exception)appException);
                    this.receivedUserExceptionNotDII(exception, newException);
                }
                if (newException != exception) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
                if (newException instanceof ApplicationException) {
                    throw (ApplicationException)newException;
                }
                CDRInputObject cDRInputObject = inputObject;
                return cDRInputObject;
            }
            if (messageMediator.isLocationForwardReply()) {
                this.generalMessage("received location forward");
                this.getContactInfoListIterator(orb).reportRedirect(messageMediator.getContactInfo(), messageMediator.getForwardedIOR());
                Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(3, null);
                if (!(newException instanceof RemarshalException)) {
                    exception = newException;
                }
                if (exception != null) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                throw wrapper.statementNotReachable5();
            }
            if (messageMediator.isDifferentAddrDispositionRequestedReply()) {
                this.generalMessage("received different addressing dispostion request");
                this.getContactInfoListIterator(orb).reportAddrDispositionRetry(messageMediator.getContactInfo(), messageMediator.getAddrDispositionReply());
                Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(5, null);
                if (!(newException instanceof RemarshalException)) {
                    exception = newException;
                }
                if (exception != null) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                throw wrapper.statementNotReachable6();
            }
            this.generalMessage("received normal response");
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            messageMediator.handleDIIReply(inputObject);
            exception = orb.getPIHandler().invokeClientPIEndingPoint(0, null);
            this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
            CDRInputObject cDRInputObject = inputObject;
            return cDRInputObject;
        }
        finally {
            this.exit_processResponse();
        }
    }

    @Subcontract
    protected void continueOrThrowSystemOrRemarshal(MessageMediator messageMediator, Exception exception) throws SystemException, RemarshalException {
        ORB orb = messageMediator.getBroker();
        if (exception != null) {
            if (exception instanceof RemarshalException) {
                orb.getInvocationInfo().setIsRetryInvocation(true);
                this.unregisterWaiter(orb);
                throw (RemarshalException)((Object)exception);
            }
            throw (SystemException)((Object)exception);
        }
    }

    protected ContactInfoListIterator getContactInfoListIterator(ORB orb) {
        return (ContactInfoListIterator)orb.getInvocationInfo().getContactInfoListIterator();
    }

    @Subcontract
    protected void registerWaiter(MessageMediator messageMediator) {
        if (messageMediator.getConnection() != null) {
            messageMediator.getConnection().registerWaiter(messageMediator);
        }
    }

    @Subcontract
    protected void unregisterWaiter(ORB orb) {
        MessageMediator messageMediator = orb.getInvocationInfo().getMessageMediator();
        if (messageMediator != null && messageMediator.getConnection() != null) {
            messageMediator.getConnection().unregisterWaiter(messageMediator);
        }
    }

    @Subcontract
    protected void addServiceContexts(MessageMediator messageMediator) {
        ORB orb = messageMediator.getBroker();
        Connection c = messageMediator.getConnection();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        ServiceContexts contexts = null;
        if (ORBUtility.getEncodingVersion() != 0) {
            contexts = messageMediator.getRequestServiceContexts();
            ORBVersionServiceContext lsc = ServiceContextDefaults.getORBVersionServiceContext();
            contexts.put(lsc);
            return;
        }
        if (c != null && giopVersion.equals(GIOPVersion.V1_2) && c.getBroker().getORBData().alwaysSendCodeSetServiceContext()) {
            contexts = !c.isPostInitialContexts() ? messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.CLIENT_INITIAL) : messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.CLIENT_SUBSEQUENT);
            this.addCodeSetServiceContext(c, contexts, giopVersion);
            messageMediator.setRequestServiceContexts(contexts);
        } else {
            contexts = messageMediator.getRequestServiceContexts();
            this.addCodeSetServiceContext(c, contexts, giopVersion);
            contexts.put(this.msfvc);
            contexts.put(this.ovsc);
            if (c != null && !c.isPostInitialContexts()) {
                SendingContextServiceContext scsc = ServiceContextDefaults.makeSendingContextServiceContext(orb.getFVDCodeBaseIOR());
                contexts.put(scsc);
            }
        }
    }

    @Subcontract
    protected void consumeServiceContexts(ORB orb, MessageMediator messageMediator) {
        ServiceContexts ctxts = messageMediator.getReplyServiceContexts();
        if (ctxts == null) {
            return;
        }
        ServiceContext sc = ctxts.get(6);
        if (sc != null) {
            SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
            IOR ior = scsc.getIOR();
            try {
                if (messageMediator.getConnection() != null) {
                    messageMediator.getConnection().setCodeBaseIOR(ior);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw wrapper.badStringifiedIor(t);
            }
        }
        if ((sc = ctxts.get(1313165056)) != null) {
            ORBVersionServiceContext lsc = (ORBVersionServiceContext)sc;
            ORBVersion version = lsc.getVersion();
            orb.setORBVersion(version);
        }
        this.getExceptionDetailMessage(messageMediator, wrapper);
    }

    @Subcontract
    protected void getExceptionDetailMessage(MessageMediator messageMediator, ORBUtilSystemException wrapper) {
        ServiceContext sc = messageMediator.getReplyServiceContexts().get(14);
        if (sc == null) {
            return;
        }
        if (!(sc instanceof UnknownServiceContext)) {
            throw wrapper.badExceptionDetailMessageServiceContextType();
        }
        byte[] data = ((UnknownServiceContext)sc).getData();
        EncapsInputStream in = new EncapsInputStream((org.omg.CORBA.ORB)messageMediator.getBroker(), data, data.length);
        in.consumeEndian();
        String msg = "----------BEGIN server-side stack trace----------\n" + in.read_wstring() + "\n----------END server-side stack trace----------";
        messageMediator.setReplyExceptionDetailMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Subcontract
    public void endRequest(ORB orb, Object self, CDRInputObject inputObject) {
        try {
            this.exit_clientDecoding();
            MessageMediator messageMediator = orb.getInvocationInfo().getMessageMediator();
            if (messageMediator != null) {
                CDROutputObject outputObj;
                CDRInputObject inputObj;
                ORBUtility.popEncVersionFromThreadLocalState();
                if (messageMediator.getConnection() != null) {
                    messageMediator.sendCancelRequestIfFinalFragmentNotSent();
                }
                if ((inputObj = messageMediator.getInputObject()) != null) {
                    inputObj.close();
                }
                if ((outputObj = messageMediator.getOutputObject()) != null) {
                    outputObj.close();
                }
            }
            this.unregisterWaiter(orb);
            orb.getPIHandler().cleanupClientPIRequest();
        }
        catch (IOException ex) {
            this.reportException("ignoring IOException", ex);
        }
        finally {
            this.exit_totalRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected void performCodeSetNegotiation(MessageMediator messageMediator) {
        Connection conn = messageMediator.getConnection();
        if (conn == null) {
            return;
        }
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        if (giopVersion.equals(GIOPVersion.V1_0)) {
            return;
        }
        IOR ior = messageMediator.getContactInfo().getEffectiveTargetIOR();
        Connection connection = conn;
        synchronized (connection) {
            if (conn.getCodeSetContext() != null) {
                return;
            }
            IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            Iterator<TaggedComponent> iter = temp.iteratorById(1);
            if (!iter.hasNext()) {
                return;
            }
            CodeSetComponentInfo serverCodeSets = ((CodeSetsComponent)iter.next()).getCodeSetComponentInfo();
            CodeSetComponentInfo.CodeSetContext result = CodeSetConversion.impl().negotiate(conn.getBroker().getORBData().getCodeSetComponentInfo(), serverCodeSets);
            conn.setCodeSetContext(result);
        }
    }

    @Subcontract
    protected void addCodeSetServiceContext(Connection conn, ServiceContexts ctxs, GIOPVersion giopVersion) {
        if (giopVersion.equals(GIOPVersion.V1_0) || conn == null) {
            return;
        }
        CodeSetComponentInfo.CodeSetContext codeSetCtx = null;
        if (conn.getBroker().getORBData().alwaysSendCodeSetServiceContext() || !conn.isPostInitialContexts()) {
            codeSetCtx = conn.getCodeSetContext();
        }
        if (codeSetCtx == null) {
            return;
        }
        CodeSetServiceContext cssc = ServiceContextDefaults.makeCodeSetServiceContext(codeSetCtx);
        ctxs.put(cssc);
    }

    @Subcontract
    protected String peekUserExceptionId(CDRInputObject inputObject) {
        CDRInputObject cdrInputObject = inputObject;
        cdrInputObject.mark(Integer.MAX_VALUE);
        String result = cdrInputObject.read_string();
        cdrInputObject.reset();
        return result;
    }
}

