/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DynamicClassWriter;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;

public class SDOClassLoader
extends ClassLoader {
    private Map<String, Class> generatedClasses;
    private HelperContext aHelperContext;

    public SDOClassLoader(ClassLoader delegateLoader, HelperContext aContext) {
        super(delegateLoader);
        this.aHelperContext = aContext;
        this.generatedClasses = new HashMap<String, Class>();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class javaClass = this.generatedClasses.get(className);
        if (javaClass != null) {
            return javaClass;
        }
        return this.getParent().loadClass(className);
    }

    public Class loadClass(String className, SDOType type) throws ClassNotFoundException {
        Class javaClass;
        block6: {
            javaClass = this.generatedClasses.get(className);
            if (javaClass != null) {
                return javaClass;
            }
            try {
                javaClass = this.getParent().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                javaClass = this.createGeneric(className, type);
                if (javaClass == null) {
                    throw e;
                }
            }
            catch (NoClassDefFoundError error) {
                javaClass = this.createGeneric(className, type);
                if (javaClass != null) break block6;
                throw error;
            }
        }
        if (!type.isDataType() && null != this.aHelperContext && null != this.aHelperContext.getTypeHelper()) {
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getImplClassesToSDOType().put(javaClass, type);
        }
        return javaClass;
    }

    public Class createGeneric(String className, SDOType type) {
        Class<?> javaClass = this.generatedClasses.get(className);
        if (javaClass != null) {
            return javaClass;
        }
        if (className == null) {
            return null;
        }
        DynamicClassWriter dcWriter = new DynamicClassWriter(className, type, this.aHelperContext);
        byte[] bytes = dcWriter.createClass();
        javaClass = this.defineClass(className, bytes, 0, bytes.length);
        this.generatedClasses.put(className, javaClass);
        return javaClass;
    }
}

