/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.xml.sax.InputSource;

public class SchemaResolverWrapper {
    private SchemaResolver schemaResolver;
    private List<String> systemIdList;

    public SchemaResolverWrapper(SchemaResolver resolver) {
        this.schemaResolver = resolver;
        this.systemIdList = new ArrayList<String>();
    }

    public Source resolveSchema(Source sourceXSD) {
        Source resolvedSchemaSource = null;
        if (sourceXSD instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)sourceXSD;
            if (null == streamSource.getInputStream() && null == streamSource.getReader()) {
                resolvedSchemaSource = this.resolveSchema(streamSource.getPublicId(), streamSource.getSystemId());
            }
        } else if (sourceXSD instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)sourceXSD;
            InputSource inputSource = saxSource.getInputSource();
            if (null == inputSource) {
                resolvedSchemaSource = this.resolveSchema(saxSource.getSystemId());
            } else if (null == inputSource.getByteStream() && null == inputSource.getCharacterStream()) {
                resolvedSchemaSource = this.resolveSchema(inputSource.getPublicId(), inputSource.getSystemId());
            }
        } else if (sourceXSD instanceof DOMSource) {
            DOMSource domSource = (DOMSource)sourceXSD;
            if (null == domSource.getNode()) {
                resolvedSchemaSource = this.resolveSchema(domSource.getSystemId());
            }
        } else if (null != sourceXSD.getSystemId()) {
            resolvedSchemaSource = this.resolveSchema(sourceXSD.getSystemId());
        }
        if (resolvedSchemaSource != null) {
            return resolvedSchemaSource;
        }
        return sourceXSD;
    }

    public Source resolveSchema(Source sourceXSD, String namespace, String schemaLocation) {
        String sysId;
        this.addSchemaToList(sourceXSD.getSystemId());
        Source schemaSource = this.schemaResolver.resolveSchema(sourceXSD, namespace, schemaLocation);
        if (schemaSource != null && this.shouldProcessSchema(sysId = schemaSource.getSystemId())) {
            return schemaSource;
        }
        return null;
    }

    public Source resolveSchema(String systemId) {
        return this.resolveSchema(null, systemId);
    }

    public Source resolveSchema(String publicId, String systemId) {
        if (!this.addSchemaToList(systemId)) {
            return null;
        }
        try {
            InputSource inputSource = this.schemaResolver.resolveEntity(publicId, systemId);
            if (inputSource != null) {
                return new SAXSource(inputSource);
            }
        }
        catch (Exception ex) {
            throw SDOException.errorResolvingSchema(ex);
        }
        return null;
    }

    private boolean shouldProcessSchema(String systemId) {
        if (systemId == null) {
            return true;
        }
        return this.addSchemaToList(systemId);
    }

    private boolean addSchemaToList(String systemId) {
        if (systemId == null || this.systemIdList.contains(systemId)) {
            return false;
        }
        this.systemIdList.add(systemId);
        return true;
    }

    public SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }
}

