/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.linkkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.internal.widgets.linkkit.LinkOperationHandler;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Link";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};
    static final String PROP_TEXT = "text";

    @Override
    public void preserveValues(Widget widget) {
        Link link = (Link)widget;
        ControlLCAUtil.preserveValues(link);
        WidgetLCAUtil.preserveCustomVariant(link);
        WidgetLCAUtil.preserveProperty((Widget)link, PROP_TEXT, link.getText());
        WidgetLCAUtil.preserveListenSelection(link);
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        Link link = (Link)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(link, TYPE);
        remoteObject.setHandler(new LinkOperationHandler(link));
        remoteObject.set("parent", WidgetUtil.getId(link.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(link, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        Link link = (Link)widget;
        ControlLCAUtil.renderChanges(link);
        WidgetLCAUtil.renderCustomVariant(link);
        LinkLCA.renderText(link);
        WidgetLCAUtil.renderListenSelection(link);
    }

    private static void renderText(Link link) {
        String newValue = link.getText();
        if (WidgetLCAUtil.hasChanged(link, PROP_TEXT, newValue, "")) {
            RemoteObjectFactory.getRemoteObject(link).set(PROP_TEXT, LinkLCA.getTextObject(link));
        }
    }

    private static JsonArray getTextObject(Link link) {
        ILinkAdapter adapter = link.getAdapter(ILinkAdapter.class);
        String displayText = adapter.getDisplayText();
        Point[] offsets = adapter.getOffsets();
        JsonArray result = new JsonArray();
        int length = displayText.length();
        int pos = 0;
        int i = 0;
        while (i < offsets.length) {
            int start = offsets[i].x;
            int end = offsets[i].y + 1;
            if (pos < start) {
                result.add(new JsonArray().add(displayText.substring(pos, start)).add(JsonObject.NULL));
            }
            if (start < end) {
                result.add(new JsonArray().add(displayText.substring(start, end)).add(i));
            }
            pos = end;
            ++i;
        }
        if (pos < length) {
            result.add(new JsonArray().add(displayText.substring(pos, length)).add(JsonObject.NULL));
        }
        return result;
    }
}

