/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableOperationHandler
extends ControlOperationHandler<Table> {
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String METHOD_RENDER_TOOLTIP_TEXT = "renderToolTipText";

    public TableOperationHandler(Table table) {
        super(table);
    }

    @Override
    public void handleSet(Table table, JsonObject properties) {
        super.handleSet(table, properties);
        this.handleSetSelection(table, properties);
        this.handleSetScrollLeft(table, properties);
        this.handleSetTopItemIndex(table, properties);
        this.handleSetFocusItem(table, properties);
    }

    @Override
    public void handleCall(Table table, String method, JsonObject properties) {
        if (METHOD_RENDER_TOOLTIP_TEXT.equals(method)) {
            this.handleCallRenderToolTipText(table, properties);
        }
    }

    @Override
    public void handleNotify(Table table, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(table, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(table, properties);
        } else if ("SetData".equals(eventName)) {
            this.handleNotifySetData(table, properties);
        } else {
            super.handleNotify(table, eventName, properties);
        }
    }

    public void handleSetSelection(Table table, JsonObject properties) {
        JsonValue values = properties.get(PROP_SELECTION);
        if (values != null) {
            JsonArray itemIds = values.asArray();
            int[] newSelection = new int[itemIds.size()];
            int i = 0;
            while (i < newSelection.length) {
                String itemId = itemIds.get(i).asString();
                TableItem item = TableOperationHandler.getItem(table, itemId);
                newSelection[i] = item != null ? table.indexOf(item) : -1;
                ++i;
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    public void handleSetScrollLeft(Table table, JsonObject properties) {
        JsonValue value = properties.get(PROP_SCROLL_LEFT);
        if (value != null) {
            int scrollLeft = value.asInt();
            TableOperationHandler.getTableAdapter(table).setLeftOffset(scrollLeft);
            TableOperationHandler.setScrollBarSelection(table.getHorizontalBar(), scrollLeft);
        }
    }

    public void handleSetTopItemIndex(Table table, JsonObject properties) {
        JsonValue value = properties.get(PROP_TOP_ITEM_INDEX);
        if (value != null) {
            int topItemIndex = value.asInt();
            table.setTopIndex(topItemIndex);
            int scrollTop = topItemIndex * table.getItemHeight();
            TableOperationHandler.setScrollBarSelection(table.getVerticalBar(), scrollTop);
        }
    }

    public void handleSetFocusItem(Table table, JsonObject properties) {
        TableItem item;
        JsonValue value = properties.get(PROP_FOCUS_ITEM);
        if (value != null && (item = TableOperationHandler.getItem(table, value.asString())) != null) {
            TableOperationHandler.getTableAdapter(table).setFocusIndex(table.indexOf(item));
        }
    }

    public void handleCallRenderToolTipText(Table table, JsonObject properties) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        ICellToolTipProvider provider = adapter.getCellToolTipProvider();
        if (provider != null) {
            TableItem item = TableOperationHandler.getItem(table, properties.get("item").asString());
            int columnIndex = properties.get("column").asInt();
            if (item != null && (columnIndex == 0 || columnIndex < table.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    public void handleNotifySelection(Table table, JsonObject properties) {
        TableItem item = TableOperationHandler.getItem(table, properties.get("item").asString());
        if (item != null) {
            Event event = TableOperationHandler.createSelectionEvent(13, properties);
            event.item = item;
            table.notifyListeners(13, event);
        }
    }

    public void handleNotifyDefaultSelection(Table table, JsonObject properties) {
        TableItem item = TableOperationHandler.getItem(table, properties.get("item").asString());
        if (item == null) {
            item = TableOperationHandler.getFocusItem(table);
        }
        Event event = TableOperationHandler.createSelectionEvent(14, properties);
        event.item = item;
        table.notifyListeners(14, event);
    }

    public void handleNotifySetData(Table table, JsonObject properties) {
    }

    private static TableItem getItem(Table table, String itemId) {
        TableItem item;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            int index = Integer.parseInt(idParts[1]);
            item = table.getItem(index);
        } else {
            item = (TableItem)WidgetUtil.find(table, itemId);
        }
        return item;
    }

    private static void setScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
        }
    }

    private static TableItem getFocusItem(Table table) {
        TableItem result = null;
        int focusIndex = TableOperationHandler.getTableAdapter(table).getFocusIndex();
        if (focusIndex != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    @Override
    protected boolean allowMouseEvent(Table table, int x, int y) {
        return super.allowMouseEvent(table, x, y) && y >= table.getHeaderHeight();
    }

    private static ITableAdapter getTableAdapter(Table table) {
        return table.getAdapter(ITableAdapter.class);
    }
}

