/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolbarkit;

import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBarThemeAdapter
extends ControlThemeAdapterImpl {
    @Override
    protected void configureMatcher(WidgetMatcher matcher) {
        super.configureMatcher(matcher);
        matcher.addStyle("FLAT", 0x800000);
        matcher.addState("first", ToolBarThemeAdapter.createFirstItemMatcher());
        matcher.addState("last", ToolBarThemeAdapter.createLastItemMatcher());
    }

    public BoxDimensions getItemBorder(ToolItem item) {
        return this.getCssBorder("ToolItem", item);
    }

    public BoxDimensions getItemPadding(ToolItem item) {
        return this.getCssBoxDimensions((String)"ToolItem", (String)"padding", (Widget)item).dimensions;
    }

    public BoxDimensions getToolBarPadding(Control control) {
        return this.getCssBoxDimensions((String)"ToolBar", (String)"padding", (Widget)control).dimensions;
    }

    public int getToolBarSpacing(Control control) {
        return this.getCssDimension("ToolBar", "spacing", control);
    }

    public int getItemSpacing(ToolItem item) {
        return this.getCssDimension("ToolItem", "spacing", item);
    }

    public int getSeparatorWidth(Control control) {
        return this.getCssDimension("ToolItem-Separator", "width", control);
    }

    public Size getDropDownImageSize(Control control) {
        return this.getCssImageSize("ToolItem-DropDownIcon", "background-image", control);
    }

    private static WidgetMatcher.Constraint createFirstItemMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof ToolItem) {
                    ToolItem item = (ToolItem)widget;
                    ToolBar toolBar = item.getParent();
                    return toolBar.getItem(0) == item;
                }
                return false;
            }
        };
    }

    private static WidgetMatcher.Constraint createLastItemMatcher() {
        return new WidgetMatcher.Constraint(){

            @Override
            public boolean matches(Widget widget) {
                if (widget instanceof ToolItem) {
                    ToolItem item = (ToolItem)widget;
                    ToolBar toolBar = item.getParent();
                    return toolBar.getItem(toolBar.getItemCount() - 1) == item;
                }
                return false;
            }
        };
    }
}

