/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

class RestoreScrolledCompositeOriginsVisitor
implements WidgetTreeVisitor {
    RestoreScrolledCompositeOriginsVisitor() {
    }

    @Override
    public boolean visit(Widget widget) {
        if (widget instanceof ScrolledComposite) {
            ScrolledComposite scrolledComposite = (ScrolledComposite)widget;
            RestoreScrolledCompositeOriginsVisitor.restoreSize(scrolledComposite);
            RestoreScrolledCompositeOriginsVisitor.restoreContentSize(scrolledComposite);
            RestoreScrolledCompositeOriginsVisitor.restoreOrigin(scrolledComposite);
        }
        return true;
    }

    private static void restoreSize(ScrolledComposite composite) {
        Point oldSize = RestoreScrolledCompositeOriginsVisitor.getBufferedSize(composite);
        if (oldSize != null) {
            composite.setSize(oldSize);
            composite.setData("org.eclipse.rap.sc-size", null);
        }
    }

    private static void restoreOrigin(ScrolledComposite composite) {
        Point oldOrigin = RestoreScrolledCompositeOriginsVisitor.getBufferedOrigin(composite);
        if (oldOrigin != null) {
            composite.setOrigin(oldOrigin);
            composite.setData("org.eclipse.rap.sc-origin", null);
        }
    }

    private static void restoreContentSize(ScrolledComposite composite) {
        Control content = composite.getContent();
        if (content != null) {
            RestoreScrolledCompositeOriginsVisitor.restoreContentSize(content);
        }
    }

    private static void restoreContentSize(Control content) {
        Point size = RestoreScrolledCompositeOriginsVisitor.getBufferedContentSize(content);
        if (size != null) {
            content.setSize(size);
            content.setData("org.eclipse.rap.content-size", null);
        }
    }

    private static Point getBufferedContentSize(Control content) {
        return (Point)content.getData("org.eclipse.rap.content-size");
    }

    private static Point getBufferedOrigin(ScrolledComposite composite) {
        return (Point)composite.getData("org.eclipse.rap.sc-origin");
    }

    private static Point getBufferedSize(ScrolledComposite composite) {
        return (Point)composite.getData("org.eclipse.rap.sc-size");
    }
}

