/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.List;

public final class AppearanceWriter {
    private AppearanceWriter() {
    }

    public static String createAppearanceTheme(List<String> appearances) {
        StringBuilder code = new StringBuilder();
        AppearanceWriter.appendHead(code);
        AppearanceWriter.appendAppearances(code, appearances);
        AppearanceWriter.appendTail(code);
        return code.toString();
    }

    private static void appendHead(StringBuilder code) {
        code.append("rwt.theme.AppearanceManager.getInstance().setCurrentTheme( {\n");
        code.append("  name : \"rwtAppearance\",\n");
        code.append("  appearances : {\n");
    }

    private static void appendAppearances(StringBuilder code, List<String> appearances) {
        boolean valueWritten = false;
        for (String appearance : appearances) {
            if (valueWritten) {
                code.append(",\n");
            }
            code.append(appearance);
            valueWritten = true;
        }
    }

    private static void appendTail(StringBuilder code) {
        code.append("\n");
        code.append("  }\n");
        code.append("} );\n");
    }
}

