/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.UAElementFactory;
import org.eclipse.help.internal.dynamic.DocumentProcessor;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.FilterHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.CheatSheetEvaluationContext;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.parser.CompositeCheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetCommand;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParserException;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.IExecutableItem;
import org.eclipse.ui.internal.cheatsheets.data.IPerformWhenItem;
import org.eclipse.ui.internal.cheatsheets.data.ISubItemItem;
import org.eclipse.ui.internal.cheatsheets.data.IncompatibleSiblingChecker;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.ParserInput;
import org.eclipse.ui.internal.cheatsheets.data.ParserStatusUtility;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CheatSheetParser
implements IStatusContainer {
    private static final String TRUE_STRING = "true";
    private DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
    private DocumentProcessor processor;
    private ArrayList itemExtensionContainerList;
    public static final int COMPOSITE_ONLY = 1;
    public static final int SIMPLE_ONLY = 2;
    public static final int ANY = 3;
    private IStatus status;
    private int commandCount;
    private int actionCount;

    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void addStatus(int severity, String message, Throwable exception) {
        this.status = ParserStatusUtility.addStatus(this.status, severity, message, exception);
    }

    private StringBuffer escapeXMLCharacters(StringBuffer text) {
        int length = text.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    String tmp = "";
                    tmp = i + 5 < length ? text.substring(i, i + 5).toLowerCase() : text.substring(i, length).toLowerCase();
                    if (tmp.startsWith("<b>") || tmp.startsWith("</b>") || tmp.startsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    String tmp = "";
                    tmp = i >= 5 ? text.substring(i - 5, i + 1).toLowerCase() : text.substring(0, i + 1).toLowerCase();
                    if (tmp.endsWith("<b>") || tmp.endsWith("</b>") || tmp.endsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\t': {
                    result.append(' ');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result;
    }

    private Node findNode(Node startNode, String nodeName) {
        if (startNode == null) {
            return null;
        }
        if (startNode.getNodeName().equals(nodeName)) {
            return startNode;
        }
        NodeList nodes = startNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void handleExecutable(IExecutableItem item, Node executableNode, AbstractExecutable executable) throws CheatSheetParserException {
        NamedNodeMap attributes;
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)executableNode);
        String[] params = null;
        if (executable instanceof CheatSheetCommand) {
            ++this.commandCount;
        }
        if (executable instanceof Action) {
            ++this.actionCount;
        }
        if ((attributes = executableNode.getAttributes()) != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                block20: {
                    Node attribute = attributes.item(x);
                    String attributeName = attribute.getNodeName();
                    if (attribute != null && attributeName != null) {
                        if (attributeName.equals("confirm")) {
                            executable.setConfirm(attribute.getNodeValue().equals(TRUE_STRING));
                        } else if (attributeName.equals("when")) {
                            executable.setWhen(attribute.getNodeValue());
                        } else if (attributeName.equals("required")) {
                            executable.setRequired(attribute.getNodeValue().equals(TRUE_STRING));
                        } else if (!attributeName.equals("translate")) {
                            if (executable.hasParams() && attributeName.startsWith("param")) {
                                try {
                                    String paramNum;
                                    int num;
                                    if (params == null) {
                                        params = new String[9];
                                    }
                                    if ((num = Integer.parseInt(paramNum = attributeName.substring("param".length())) - 1) > -1 && num < 9) {
                                        params[num] = attribute.getNodeValue();
                                        break block20;
                                    }
                                    String message = NLS.bind((String)Messages.get().ERROR_PARSING_PARAM_INVALIDRANGE, (Object[])new Object[]{attributeName, paramNum});
                                    this.addStatus(4, message, null);
                                }
                                catch (NumberFormatException e) {
                                    String message = Messages.get().ERROR_PARSING_PARAM_INVALIDNUMBER;
                                    this.addStatus(4, message, e);
                                }
                            } else if (!executable.handleAttribute(attribute)) {
                                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, executableNode.getNodeName()});
                                this.addStatus(2, message, null);
                            }
                        }
                    }
                }
                ++x;
            }
            String errorMessage = executable.checkAttributes(executableNode);
            if (errorMessage != null) {
                throw new CheatSheetParserException(errorMessage);
            }
        }
        this.checkForNoChildren(executableNode);
        executable.setParams(params);
        item.setExecutable(executable);
    }

    private void checkForNoChildren(Node parentNode) {
        NodeList nodes = parentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), parentNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
    }

    private void handleCheatSheetAttributes(CheatSheet cheatSheet, Node cheatSheetNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)cheatSheet);
        Assert.isNotNull((Object)cheatSheetNode);
        Assert.isTrue((boolean)cheatSheetNode.getNodeName().equals("cheatsheet"));
        boolean title = false;
        NamedNodeMap attributes = cheatSheetNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        cheatSheet.setTitle(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, cheatSheetNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_TITLE, (Object[])new Object[]{cheatSheetNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private void handleConditionalSubItem(Item item, Node conditionalSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)conditionalSubItemNode);
        Assert.isTrue((boolean)conditionalSubItemNode.getNodeName().equals("conditional-subitem"));
        ConditionalSubItem conditionalSubItem = new ConditionalSubItem();
        boolean condition = false;
        NamedNodeMap attributes = conditionalSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        conditionalSubItem.setCondition(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, conditionalSubItemNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_CONDITION, (Object[])new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = conditionalSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(conditionalSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), conditionalSubItemNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_SUBITEM, (Object[])new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(conditionalSubItem);
    }

    private void handleDescription(Item item, Node startNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)startNode);
        Node descriptionNode = this.findNode(startNode, "description");
        if (descriptionNode == null) {
            Node parentNode = startNode;
            if (startNode.getNodeName().equals("description")) {
                parentNode = startNode.getParentNode();
            }
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_DESCRIPTION, (Object[])new Object[]{parentNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        String text = this.handleMarkedUpText(descriptionNode, startNode, "description");
        item.setDescription(text);
    }

    private String handleMarkedUpText(Node nodeContainingText, Node startNode, String nodeName) {
        NodeList nodes = nodeContainingText.getChildNodes();
        StringBuffer text = new StringBuffer();
        boolean containsMarkup = false;
        boolean isLeadingTrimRequired = true;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                String nodeValue = node.getNodeValue();
                if (isLeadingTrimRequired) {
                    nodeValue = this.trimLeadingWhitespace(nodeValue);
                }
                text.append(nodeValue);
                isLeadingTrimRequired = false;
            } else if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("b")) {
                    containsMarkup = true;
                    text.append("<b>");
                    text.append(node.getFirstChild().getNodeValue());
                    text.append("</b>");
                    isLeadingTrimRequired = false;
                } else if (node.getNodeName().equals("br")) {
                    containsMarkup = true;
                    text.append("<br/>");
                    isLeadingTrimRequired = true;
                } else {
                    this.warnUnknownMarkupElement(startNode, nodeName, node);
                }
            }
            ++i;
        }
        if (containsMarkup) {
            text = this.escapeXMLCharacters(text);
            text.insert(0, "<form><p>");
            text.append("</p></form>");
        } else {
            this.deTab(text);
        }
        return text.toString().trim();
    }

    private void deTab(StringBuffer text) {
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\t') {
                text.setCharAt(i, ' ');
            }
            ++i;
        }
    }

    private String trimLeadingWhitespace(String nodeValue) {
        int firstNonWhitespaceIndex = 0;
        while (firstNonWhitespaceIndex < nodeValue.length() && Character.isWhitespace(nodeValue.charAt(firstNonWhitespaceIndex))) {
            ++firstNonWhitespaceIndex;
        }
        if (firstNonWhitespaceIndex > 0) {
            return nodeValue.substring(firstNonWhitespaceIndex, nodeValue.length());
        }
        return nodeValue;
    }

    private void warnUnknownMarkupElement(Node startNode, String nodeName, Node node) {
        Node parentNode = startNode;
        if (startNode.getNodeName().equals(nodeName)) {
            parentNode = startNode.getParentNode();
        }
        String message = "description".equals(nodeName) ? NLS.bind((String)Messages.get().WARNING_PARSING_DESCRIPTION_UNKNOWN_ELEMENT, (Object[])new Object[]{parentNode.getNodeName(), node.getNodeName()}) : NLS.bind((String)Messages.get().WARNING_PARSING_ON_COMPLETION_UNKNOWN_ELEMENT, (Object[])new Object[]{parentNode.getNodeName(), node.getNodeName()});
        this.addStatus(2, message, null);
    }

    private void handleOnCompletion(Item item, Node onCompletionNode) {
        String text = this.handleMarkedUpText(onCompletionNode, onCompletionNode, "onCompletion");
        item.setCompletionMessage(text);
    }

    private void handleIntroNode(CheatSheet cheatSheet, Node introNode) throws CheatSheetParserException {
        Item introItem = new Item();
        introItem.setTitle(Messages.get().CHEAT_SHEET_INTRO_TITLE);
        this.handleIntroAttributes(introItem, introNode);
        boolean hasDescription = false;
        NodeList nodes = introNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String message;
            Node node = nodes.item(i);
            if (node.getNodeName().equals("description")) {
                if (hasDescription) {
                    message = NLS.bind((String)Messages.get().ERROR_PARSING_MULTIPLE_DESCRIPTION, (Object[])new Object[]{introNode.getNodeName()});
                    this.addStatus(4, message, null);
                } else {
                    hasDescription = true;
                    this.handleDescription(introItem, node);
                }
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), introNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        if (!hasDescription) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_DESCRIPTION, (Object[])new Object[]{introNode.getNodeName()});
            this.addStatus(4, message, null);
        }
        cheatSheet.setIntroItem(introItem);
    }

    private void handleIntroAttributes(Item item, Node introNode) {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)introNode);
        NamedNodeMap attributes = introNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, introNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
    }

    private Item handleItem(Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)itemNode);
        Assert.isTrue((boolean)itemNode.getNodeName().equals("item"));
        Item item = new Item();
        this.handleItemAttributes(item, itemNode);
        boolean hasDescription = false;
        NodeList nodes = itemNode.getChildNodes();
        IncompatibleSiblingChecker checker = new IncompatibleSiblingChecker(this, itemNode);
        int i = 0;
        while (i < nodes.getLength()) {
            String message;
            Node node = nodes.item(i);
            checker.checkElement(node.getNodeName());
            if (node.getNodeName().equals("action")) {
                this.handleExecutable(item, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                this.handleExecutable(item, node, new CheatSheetCommand());
            } else if (node.getNodeName().equals("description")) {
                if (hasDescription) {
                    message = NLS.bind((String)Messages.get().ERROR_PARSING_MULTIPLE_DESCRIPTION, (Object[])new Object[]{itemNode.getNodeName()});
                    this.addStatus(4, message, null);
                } else {
                    hasDescription = true;
                    this.handleDescription(item, node);
                }
            } else if (node.getNodeName().equals("onCompletion")) {
                this.handleOnCompletion(item, node);
            } else if (node.getNodeName().equals("subitem")) {
                this.handleSubItem(item, node);
            } else if (node.getNodeName().equals("conditional-subitem")) {
                this.handleConditionalSubItem(item, node);
            } else if (node.getNodeName().equals("repeated-subitem")) {
                this.handleRepeatedSubItem(item, node);
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(item, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), itemNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        if (!hasDescription) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_DESCRIPTION, (Object[])new Object[]{itemNode.getNodeName()});
            this.addStatus(4, message, null);
        }
        return item;
    }

    private void handleItemAttributes(Item item, Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)itemNode);
        ArrayList<AbstractItemExtensionElement[]> itemExtensionElements = new ArrayList<AbstractItemExtensionElement[]>();
        boolean title = false;
        NamedNodeMap attributes = itemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        item.setTitle(attribute.getNodeValue());
                    } else if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        item.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else if (attributeName.equals("dialog")) {
                        item.setDialog(attribute.getNodeValue().equals(TRUE_STRING));
                    } else {
                        AbstractItemExtensionElement[] ie = this.handleUnknownItemAttribute(attribute, itemNode);
                        if (ie != null) {
                            itemExtensionElements.add(ie);
                        } else {
                            String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, itemNode.getNodeName()});
                            this.addStatus(2, message, null);
                        }
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_TITLE, (Object[])new Object[]{itemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        if (itemExtensionElements != null) {
            item.setItemExtensions(itemExtensionElements);
        }
    }

    private void handlePerformWhen(IPerformWhenItem item, Node performWhenNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)performWhenNode);
        Assert.isTrue((boolean)performWhenNode.getNodeName().equals("perform-when"));
        PerformWhen performWhen = new PerformWhen();
        boolean condition = false;
        NamedNodeMap attributes = performWhenNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        performWhen.setCondition(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, performWhenNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_CONDITION, (Object[])new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean exeutable = false;
        NodeList nodes = performWhenNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                exeutable = true;
                this.handleExecutable(performWhen, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                exeutable = true;
                this.handleExecutable(performWhen, node, new CheatSheetCommand());
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), performWhenNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        if (!exeutable) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_ACTION, (Object[])new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.setPerformWhen(performWhen);
    }

    private void handleRepeatedSubItem(Item item, Node repeatedSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)repeatedSubItemNode);
        Assert.isTrue((boolean)repeatedSubItemNode.getNodeName().equals("repeated-subitem"));
        RepeatedSubItem repeatedSubItem = new RepeatedSubItem();
        boolean values = false;
        NamedNodeMap attributes = repeatedSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("values")) {
                        values = true;
                        repeatedSubItem.setValues(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, repeatedSubItemNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
        if (!values) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_VALUES, (Object[])new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = repeatedSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(repeatedSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), repeatedSubItemNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_SUBITEM, (Object[])new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(repeatedSubItem);
    }

    private void handleSubItem(ISubItemItem item, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)subItemNode);
        Assert.isTrue((boolean)subItemNode.getNodeName().equals("subitem"));
        SubItem subItem = new SubItem();
        this.handleSubItemAttributes(subItem, subItemNode);
        IncompatibleSiblingChecker checker = new IncompatibleSiblingChecker(this, subItemNode);
        NodeList nodes = subItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            checker.checkElement(node.getNodeName());
            if (node.getNodeName().equals("action")) {
                this.handleExecutable(subItem, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                this.handleExecutable(subItem, node, new CheatSheetCommand());
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(subItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), subItemNode.getNodeName()});
                this.addStatus(2, message, null);
            }
            ++i;
        }
        item.addSubItem(subItem);
    }

    private void handleSubItemAttributes(SubItem subItem, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)subItem);
        Assert.isNotNull((Object)subItemNode);
        boolean label = false;
        NamedNodeMap attributes = subItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("label")) {
                        label = true;
                        subItem.setLabel(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        subItem.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else if (attributeName.equals("when")) {
                        subItem.setWhen(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, subItemNode.getNodeName()});
                        this.addStatus(2, message, null);
                    }
                }
                ++x;
            }
        }
        if (!label) {
            String message = NLS.bind((String)Messages.get().ERROR_PARSING_NO_LABEL, (Object[])new Object[]{subItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private AbstractItemExtensionElement[] handleUnknownItemAttribute(Node item, Node node) {
        ArrayList<AbstractItemExtensionElement> al = new ArrayList<AbstractItemExtensionElement>();
        if (this.itemExtensionContainerList == null) {
            return null;
        }
        int i = 0;
        while (i < this.itemExtensionContainerList.size()) {
            AbstractItemExtensionElement itemElement;
            CheatSheetItemExtensionElement itemExtensionElement = (CheatSheetItemExtensionElement)((Object)this.itemExtensionContainerList.get(i));
            if (itemExtensionElement.getItemAttribute().equals(item.getNodeName()) && (itemElement = itemExtensionElement.createInstance()) != null) {
                itemElement.handleAttribute(item.getNodeValue());
                al.add(itemElement);
            }
            ++i;
        }
        if (al.size() == 0) {
            String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{item.getNodeName(), node.getNodeName()});
            this.addStatus(2, message, null);
        }
        return al.toArray(new AbstractItemExtensionElement[al.size()]);
    }

    public ICheatSheet parse(URL url, String pluginId, int cheatSheetKind) {
        return this.parse(new ParserInput(url, pluginId, null), cheatSheetKind);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ICheatSheet parse(ParserInput input, int cheatSheetKind) {
        Document document;
        String filename;
        InputSource inputSource;
        InputStream is;
        block34: {
            this.status = Status.OK_STATUS;
            this.commandCount = 0;
            this.actionCount = 0;
            if (input == null) {
                return null;
            }
            if (input.getErrorMessage() != null) {
                this.addStatus(4, input.getErrorMessage(), null);
            }
            is = null;
            inputSource = null;
            filename = "";
            URL url = input.getUrl();
            if (input.getXml() != null) {
                StringReader reader = new StringReader(input.getXml());
                inputSource = new InputSource(reader);
            } else {
                if (input.getUrl() == null) return null;
                try {
                    is = url.openStream();
                    if (is != null) {
                        inputSource = new InputSource(is);
                    }
                }
                catch (Exception e) {
                    String message = NLS.bind((String)Messages.get().ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
                    this.addStatus(4, message, e);
                    return null;
                }
            }
            if (input.getUrl() != null) {
                filename = url.getFile();
            }
            if (this.documentBuilder != null) break block34;
            this.addStatus(4, Messages.get().ERROR_DOCUMENT_BUILDER_NOT_INIT, null);
            try {
                is.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            document = this.documentBuilder.parse(inputSource);
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.get().ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{filename});
            this.addStatus(4, message, e);
            try {
                is.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
        catch (SAXParseException spe) {
            String message = NLS.bind((String)Messages.get().ERROR_SAX_PARSING_WITH_LOCATION, (Object[])new Object[]{filename, new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())});
            this.addStatus(4, message, spe);
            try {
                is.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
        catch (SAXException se) {
            String message = NLS.bind((String)Messages.get().ERROR_SAX_PARSING, (Object[])new Object[]{filename});
            this.addStatus(4, message, se);
            {
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        if (this.processor == null) {
            DocumentReader reader = new DocumentReader();
            this.processor = new DocumentProcessor(new ProcessorHandler[]{new FilterHandler((IEvaluationContext)CheatSheetEvaluationContext.getContext()), new NormalizeHandler(), new IncludeHandler(reader, RWT.getLocale().getLanguage()), new ExtensionHandler(reader, RWT.getLocale().getLanguage())});
        }
        String documentPath = null;
        if (input.getPluginId() != null) {
            documentPath = String.valueOf('/') + input.getPluginId() + input.getUrl().getPath();
        }
        this.processor.process(UAElementFactory.newElement((Element)document.getDocumentElement()), documentPath);
        if (cheatSheetKind == 1 || cheatSheetKind == 3 && this.isComposite(document)) {
            CompositeCheatSheetParser compositeParser = new CompositeCheatSheetParser();
            CompositeCheatSheetModel result = compositeParser.parseCompositeCheatSheet(document, input.getUrl());
            this.status = compositeParser.getStatus();
            return result;
        }
        try {
            return this.parseCheatSheet(document);
        }
        catch (CheatSheetParserException e) {
            this.addStatus(4, e.getMessage(), e);
            return null;
        }
    }

    private boolean isComposite(Document document) {
        if (document != null) {
            Element rootnode = document.getDocumentElement();
            return rootnode.getNodeName().equals("compositeCheatsheet");
        }
        return false;
    }

    private CheatSheet parseCheatSheet(Document document) throws CheatSheetParserException {
        if (document != null) {
            Element rootnode = document.getDocumentElement();
            if (!rootnode.getNodeName().equals("cheatsheet")) {
                throw new CheatSheetParserException(Messages.get().ERROR_PARSING_CHEATSHEET_ELEMENT);
            }
            CheatSheet cheatSheet = new CheatSheet();
            this.handleCheatSheetAttributes(cheatSheet, rootnode);
            boolean hasItem = false;
            boolean hasIntro = false;
            CheatSheetRegistryReader reader = CheatSheetRegistryReader.getInstance();
            this.itemExtensionContainerList = reader.readItemExtensions();
            NodeList nodes = rootnode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeName().equals("item")) {
                    hasItem = true;
                    Item item = this.handleItem(node);
                    cheatSheet.addItem(item);
                } else if (node.getNodeName().equals("intro")) {
                    if (hasIntro) {
                        this.addStatus(4, Messages.get().ERROR_PARSING_MORE_THAN_ONE_INTRO, null);
                    } else {
                        hasIntro = true;
                        this.handleIntroNode(cheatSheet, node);
                    }
                } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                    String message = NLS.bind((String)Messages.get().WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), rootnode.getNodeName()});
                    this.addStatus(2, message, null);
                }
                ++i;
            }
            if (!hasIntro) {
                this.addStatus(4, Messages.get().ERROR_PARSING_NO_INTRO, null);
            }
            if (!hasItem) {
                this.addStatus(4, Messages.get().ERROR_PARSING_NO_ITEM, null);
            }
            if (this.status.getSeverity() == 4) {
                return null;
            }
            cheatSheet.setContainsCommandOrAction(this.actionCount != 0 || this.commandCount != 0);
            return cheatSheet;
        }
        throw new CheatSheetParserException(Messages.get().ERROR_PARSING_CHEATSHEET_CONTENTS);
    }

    private class NormalizeHandler
    extends ProcessorHandler {
        private static final String ELEMENT_PARAM = "param";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_VALUE = "value";
        private static final String NAME_PATH = "path";

        private NormalizeHandler() {
        }

        public short handle(UAElement element, String id) {
            if (id != null && ELEMENT_PARAM.equals(element.getElementName())) {
                String value;
                String name = element.getAttribute(ATTRIBUTE_NAME);
                if (NAME_PATH.equals(name) && (value = element.getAttribute(ATTRIBUTE_VALUE)) != null) {
                    int index = id.lastIndexOf(47);
                    element.setAttribute(ATTRIBUTE_VALUE, String.valueOf(id.substring(0, index + 1)) + value);
                }
                return 1;
            }
            return 0;
        }
    }
}

