/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationDictionary;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ReadOnlyConfigurationException;

class ConfigurationImpl
implements Configuration {
    static final String LOCATION_BOUND = "org.eclipse.equinox.cm.location.bound";
    static final String PROPERTIES_NULL = "org.eclipse.equinox.cm.properties.null";
    static final String CHANGE_COUNT = "org.eclipse.equinox.cm.change.count";
    static final String READ_ONLY = "org.eclipse.equinox.cm.readonly";
    private final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private final String factoryPid;
    private final String pid;
    private String bundleLocation;
    private ConfigurationDictionary dictionary;
    private boolean deleted = false;
    private boolean bound = false;
    private long changeCount;
    private Object storageToken;
    private boolean readOnly = false;
    private final ReentrantLock lock = new ReentrantLock();

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, String factoryPid, String pid, String bundleLocation, boolean bind) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.factoryPid = factoryPid;
        this.pid = pid;
        this.bundleLocation = bundleLocation;
        this.changeCount = 0L;
        this.bound = bind;
    }

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, Dictionary<String, ?> dictionary, Object storageToken) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.pid = (String)dictionary.get("service.pid");
        this.factoryPid = (String)dictionary.get("service.factoryPid");
        this.bundleLocation = (String)dictionary.get("service.bundleLocation");
        Boolean boundProp = (Boolean)dictionary.remove(LOCATION_BOUND);
        this.bound = boundProp == null ? false : boundProp;
        Long changeCountProp = (Long)dictionary.remove(CHANGE_COUNT);
        this.changeCount = changeCountProp == null ? 0L : changeCountProp;
        Boolean readOnlyProp = (Boolean)dictionary.remove(READ_ONLY);
        this.readOnly = readOnlyProp == null ? false : readOnlyProp;
        Boolean nullProps = (Boolean)dictionary.remove(PROPERTIES_NULL);
        if (nullProps == null || !nullProps.booleanValue()) {
            this.updateDictionary(dictionary);
        }
        this.storageToken = storageToken;
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    void checkLocked() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Thread not lock owner");
        }
    }

    boolean bind(String callerLocation) {
        this.lock();
        try {
            if (this.bundleLocation == null) {
                this.bundleLocation = callerLocation;
                this.bound = true;
                try {
                    this.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
            }
            boolean bl = callerLocation.equals(this.bundleLocation);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    boolean isBound() {
        this.lock();
        try {
            boolean bl = this.bound;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    void unbind(Bundle bundle) {
        block5: {
            this.lock();
            try {
                String callerLocation = ConfigurationAdminImpl.getLocation(bundle);
                if (!this.bound || !callerLocation.equals(this.bundleLocation)) break block5;
                this.bundleLocation = null;
                this.bound = false;
                try {
                    this.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.configurationAdminFactory.notifyLocationChanged(this, callerLocation, this.factoryPid != null);
                this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
            }
            finally {
                this.unlock();
            }
        }
    }

    public void delete() {
        Object deleteToken;
        this.lock();
        try {
            this.checkDeleted();
            this.checkReadOnly();
            this.deleted = true;
            this.configurationAdminFactory.notifyConfigurationDeleted(this, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(2, this.factoryPid, this.pid);
            deleteToken = this.storageToken;
            this.storageToken = null;
        }
        finally {
            this.unlock();
        }
        this.configurationStore.removeConfiguration(this.pid, deleteToken);
    }

    private void checkDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("deleted");
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new ReadOnlyConfigurationException("read only");
        }
    }

    String getLocation() {
        this.lock();
        try {
            String string = this.bundleLocation;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getBundleLocation() {
        this.lock();
        try {
            this.checkDeleted();
            this.configurationAdminFactory.checkConfigurePermission(this.bundleLocation, null);
            if (this.bundleLocation != null) {
                String string = this.bundleLocation;
                return string;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    String getFactoryPid(boolean checkDeleted) {
        this.lock();
        try {
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.factoryPid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getFactoryPid() {
        return this.getFactoryPid(true);
    }

    String getPid(boolean checkDeleted) {
        this.lock();
        try {
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.pid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getPid() {
        return this.getPid(true);
    }

    public Dictionary<String, Object> getProperties() {
        this.lock();
        try {
            this.checkDeleted();
            if (this.dictionary == null) {
                return null;
            }
            ConfigurationDictionary copy = this.dictionary.copy();
            ConfigurationImpl.fileAutoProperties(copy, this, false, false);
            ConfigurationDictionary configurationDictionary = copy;
            return configurationDictionary;
        }
        finally {
            this.unlock();
        }
    }

    Dictionary<String, Object> getAllProperties(boolean includeStorageKeys) {
        this.lock();
        try {
            if (this.deleted) {
                return null;
            }
            ConfigurationDictionary copy = this.getProperties();
            if (copy == null) {
                if (!includeStorageKeys) {
                    return null;
                }
                copy = new ConfigurationDictionary();
            }
            ConfigurationImpl.fileAutoProperties(copy, this, true, includeStorageKeys);
            ConfigurationDictionary configurationDictionary = copy;
            return configurationDictionary;
        }
        finally {
            this.unlock();
        }
    }

    static void fileAutoProperties(Dictionary<String, Object> dictionary, ConfigurationImpl config, boolean includeLoc, boolean includeStorageKey) {
        dictionary.put("service.pid", config.getPid(false));
        String factoryPid = config.getFactoryPid(false);
        if (factoryPid != null) {
            dictionary.put("service.factoryPid", factoryPid);
        } else {
            dictionary.remove("service.factoryPid");
        }
        if (includeLoc) {
            String loc = config.getLocation();
            if (loc != null) {
                dictionary.put("service.bundleLocation", loc);
            }
        } else {
            dictionary.remove("service.bundleLocation");
        }
        if (includeStorageKey) {
            if (config.dictionary == null) {
                dictionary.put(PROPERTIES_NULL, Boolean.TRUE);
            }
            dictionary.put(CHANGE_COUNT, config.getChangeCount());
            if (config.isBound()) {
                dictionary.put(LOCATION_BOUND, Boolean.TRUE);
            }
            dictionary.put(READ_ONLY, config.readOnly);
        }
    }

    public void setBundleLocation(String bundleLocation) {
        this.lock();
        try {
            this.checkDeleted();
            this.configurationAdminFactory.checkConfigurePermission(this.bundleLocation, null);
            this.configurationAdminFactory.checkConfigurePermission(bundleLocation, null);
            String oldLocation = this.bundleLocation;
            this.bundleLocation = bundleLocation;
            this.bound = false;
            try {
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.configurationAdminFactory.notifyLocationChanged(this, oldLocation, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
        }
        finally {
            this.unlock();
        }
    }

    public void update() throws IOException {
        this.lock();
        try {
            this.checkDeleted();
            this.checkReadOnly();
            if (this.dictionary == null) {
                this.dictionary = new ConfigurationDictionary();
            }
            ++this.changeCount;
            this.save();
            this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
        }
        finally {
            this.unlock();
        }
    }

    public void update(Dictionary<String, ?> properties) throws IOException {
        this.lock();
        try {
            this.doUpdate(properties, false);
        }
        finally {
            this.unlock();
        }
    }

    public boolean updateIfDifferent(Dictionary<String, ?> properties) throws IOException {
        this.lock();
        try {
            boolean bl = this.doUpdate(properties, true);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private boolean same(Dictionary<String, ?> properties) {
        if (this.dictionary == null) {
            return false;
        }
        if (this.dictionary.size() != properties.size()) {
            return false;
        }
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.dictionary.get(key) == null) {
                return false;
            }
            Object current = this.dictionary.get(key);
            Object newValue = properties.get(key);
            if (current.getClass().isArray()) {
                Class<?> currentComponentType;
                if (!newValue.getClass().isArray()) {
                    return false;
                }
                if (!current.getClass().getComponentType().equals(newValue.getClass().getComponentType())) {
                    current = this.convertIfPossible(current);
                    newValue = this.convertIfPossible(newValue);
                    if (!current.getClass().getComponentType().equals(newValue.getClass().getComponentType())) {
                        return false;
                    }
                }
                if (!(Long.TYPE.isAssignableFrom(currentComponentType = current.getClass().getComponentType()) ? !Arrays.equals((long[])current, (long[])newValue) : (Integer.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((int[])current, (int[])newValue) : (Short.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((short[])current, (short[])newValue) : (Character.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((char[])current, (char[])newValue) : (Byte.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((byte[])current, (byte[])newValue) : (Double.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((double[])current, (double[])newValue) : (Float.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((float[])current, (float[])newValue) : (Boolean.TYPE.isAssignableFrom(currentComponentType) ? !Arrays.equals((boolean[])current, (boolean[])newValue) : !Arrays.equals((Object[])current, (Object[])newValue)))))))))) continue;
                return false;
            }
            if (current.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private Object convertIfPossible(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] original = (Long[])array;
            long[] converted = new long[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] original = (Integer[])array;
            int[] converted = new int[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] original = (Short[])array;
            short[] converted = new short[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        if (Character.class.isAssignableFrom(componentType)) {
            Character[] original = (Character[])array;
            char[] converted = new char[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i].charValue();
                ++i;
            }
            return converted;
        }
        if (Byte.class.isAssignableFrom(componentType)) {
            Byte[] original = (Byte[])array;
            byte[] converted = new byte[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] original = (Double[])array;
            double[] converted = new double[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] original = (Float[])array;
            float[] converted = new float[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i].floatValue();
                ++i;
            }
            return converted;
        }
        if (Boolean.class.isAssignableFrom(componentType)) {
            Boolean[] original = (Boolean[])array;
            boolean[] converted = new boolean[original.length];
            int i = 0;
            while (i < original.length) {
                converted[i] = original[i];
                ++i;
            }
            return converted;
        }
        return array;
    }

    private boolean doUpdate(Dictionary<String, ?> properties, boolean checkSame) throws IOException {
        this.checkDeleted();
        this.checkReadOnly();
        if (checkSame && this.same(properties)) {
            return false;
        }
        this.updateDictionary(properties);
        ++this.changeCount;
        this.save();
        this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
        this.configurationAdminFactory.dispatchEvent(1, this.factoryPid, this.pid);
        return true;
    }

    private void save() throws IOException {
        this.checkLocked();
        this.storageToken = this.configurationStore.saveConfiguration(this.pid, this, this.storageToken);
    }

    private void updateDictionary(Dictionary<String, ?> properties) {
        ConfigurationDictionary newDictionary = new ConfigurationDictionary();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (newDictionary.get(key) == null) {
                Object value = properties.get(key);
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                    System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                    newDictionary.put(key, copyOfArray);
                    continue;
                }
                if (value instanceof Collection) {
                    newDictionary.put(key, (Object)new Vector((Collection)value));
                    continue;
                }
                newDictionary.put(key, properties.get(key));
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(key) + " is already present or is a case variant.");
        }
        newDictionary.remove("service.pid");
        newDictionary.remove("service.factoryPid");
        newDictionary.remove("service.bundleLocation");
        this.dictionary = newDictionary;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigurationImpl && this.pid.equals(((ConfigurationImpl)obj).getPid());
    }

    public int hashCode() {
        return this.pid.hashCode();
    }

    boolean isDeleted() {
        this.lock();
        try {
            boolean bl = this.deleted;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public long getChangeCount() {
        this.lock();
        try {
            this.checkDeleted();
            long l = this.changeCount;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    public Dictionary<String, Object> getProcessedProperties(ServiceReference<?> reference) {
        return this.configurationAdminFactory.modifyConfiguration(reference, this);
    }

    public void addAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        this.lock();
        try {
            this.configurationAdminFactory.checkAttributePermission(this.bundleLocation);
            Configuration.ConfigurationAttribute[] configurationAttributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration.ConfigurationAttribute attr = configurationAttributeArray[n2];
                if (Configuration.ConfigurationAttribute.READ_ONLY.equals((Object)attr)) {
                    this.readOnly = true;
                }
                ++n2;
            }
            this.save();
        }
        finally {
            this.unlock();
        }
    }

    public Set<Configuration.ConfigurationAttribute> getAttributes() {
        this.lock();
        try {
            if (this.readOnly) {
                EnumSet<Configuration.ConfigurationAttribute> enumSet = EnumSet.of(Configuration.ConfigurationAttribute.READ_ONLY);
                return enumSet;
            }
            Set<Configuration.ConfigurationAttribute> set = Collections.emptySet();
            return set;
        }
        finally {
            this.unlock();
        }
    }

    public void removeAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        this.lock();
        try {
            this.configurationAdminFactory.checkAttributePermission(this.bundleLocation);
            Configuration.ConfigurationAttribute[] configurationAttributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration.ConfigurationAttribute attr = configurationAttributeArray[n2];
                if (Configuration.ConfigurationAttribute.READ_ONLY.equals((Object)attr)) {
                    this.readOnly = false;
                }
                ++n2;
            }
            this.save();
        }
        finally {
            this.unlock();
        }
    }
}

