/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.rap.e4.internal.Activator;
import org.eclipse.rap.e4.internal.RAPEventBroker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class RAPEventObjectSupplier
extends ExtendedObjectSupplier {
    protected Map<String, Event> currentEvents = new HashMap<String, Event>();
    private Map<Subscriber, ServiceRegistration> registrations = new HashMap<Subscriber, ServiceRegistration>();
    @Inject
    @Named(value="E4Application.instanceId")
    protected String instanceId;

    static {
        if (RAPEventObjectSupplier.getEventAdmin() == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCurrentEvent(String topic, Event event) {
        Map<String, Event> map = this.currentEvents;
        synchronized (map) {
            this.currentEvents.put(topic, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentEvent(String topic) {
        Map<String, Event> map = this.currentEvents;
        synchronized (map) {
            this.currentEvents.remove(topic);
        }
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        String topic = this.getTopic(descriptor);
        EventAdmin eventAdmin = RAPEventObjectSupplier.getEventAdmin();
        if (topic == null || eventAdmin == null || topic.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        if (track) {
            this.subscribe(topic, eventAdmin, requestor);
        } else {
            this.unsubscribe(requestor);
        }
        if (!this.currentEvents.containsKey(topic)) {
            return IInjector.NOT_A_VALUE;
        }
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        if (descriptorsClass.equals(Event.class)) {
            return this.currentEvents.get(topic);
        }
        return this.currentEvents.get(topic).getProperty("org.eclipse.e4.data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(String topic, EventAdmin eventAdmin, IRequestor requestor) {
        Subscriber subscriber = new Subscriber(requestor, topic);
        Map<Subscriber, ServiceRegistration> map = this.registrations;
        synchronized (map) {
            if (this.registrations.containsKey(subscriber)) {
                return;
            }
        }
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        if (bundleContext == null) {
            throw new InjectionException("Unable to subscribe to events: org.eclipse.e4.core.di.extensions bundle is not activated");
        }
        String[] topics = new String[]{topic};
        Hashtable<String, String[]> d = new Hashtable<String, String[]>();
        ((Dictionary)d).put("event.topics", topics);
        EventHandler wrappedHandler = this.makeHandler(topic, requestor);
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)wrappedHandler, d);
        Map<Subscriber, ServiceRegistration> map2 = this.registrations;
        synchronized (map2) {
            this.registrations.put(subscriber, registration);
        }
    }

    protected EventHandler makeHandler(String topic, IRequestor requestor) {
        return new DIEventHandler(topic, requestor);
    }

    protected String getTopic(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        EventTopic qualifier = (EventTopic)descriptor.getQualifier(EventTopic.class);
        String topic = qualifier.value();
        topic = RAPEventBroker.rapifyTopic(this.instanceId, topic);
        return topic;
    }

    private static EventAdmin getEventAdmin() {
        return Activator.getDefault().getEventAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribe(IRequestor requestor) {
        if (requestor == null) {
            return;
        }
        Map<Subscriber, ServiceRegistration> map = this.registrations;
        synchronized (map) {
            Iterator<Map.Entry<Subscriber, ServiceRegistration>> i = this.registrations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Subscriber, ServiceRegistration> entry = i.next();
                Subscriber key = entry.getKey();
                if (!requestor.equals(key.getRequestor())) continue;
                ServiceRegistration registration = entry.getValue();
                registration.unregister();
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void dispose() {
        ServiceRegistration[] array;
        Map<Subscriber, ServiceRegistration> map = this.registrations;
        synchronized (map) {
            Collection<ServiceRegistration> values = this.registrations.values();
            array = values.toArray(new ServiceRegistration[values.size()]);
            this.registrations.clear();
        }
        int i = 0;
        while (i < array.length) {
            array[i].unregister();
            ++i;
        }
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    class DIEventHandler
    implements EventHandler {
        private final IRequestor requestor;
        private final String topic;

        public DIEventHandler(String topic, IRequestor requestor) {
            this.topic = topic;
            this.requestor = requestor;
        }

        public void handleEvent(Event event) {
            if (!this.requestor.isValid()) {
                RAPEventObjectSupplier.this.unsubscribe(this.requestor);
                return;
            }
            RAPEventObjectSupplier.this.addCurrentEvent(this.topic, event);
            this.requestor.resolveArguments(false);
            RAPEventObjectSupplier.this.removeCurrentEvent(this.topic);
            this.requestor.execute();
        }
    }

    private static class Subscriber {
        private IRequestor requestor;
        private String topic;

        public Subscriber(IRequestor requestor, String topic) {
            this.requestor = requestor;
            this.topic = topic;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.requestor == null ? 0 : this.requestor.hashCode());
            result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
            return result;
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subscriber other = (Subscriber)obj;
            if (this.requestor == null ? other.requestor != null : !this.requestor.equals(other.requestor)) {
                return false;
            }
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }
    }
}

