/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import jakarta.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

public class WorkbenchStatusReporter
extends StatusReporter {
    @Inject
    @Optional
    IShellProvider shellProvider;
    @Inject
    Logger logger;
    @Inject
    @Optional
    BundleContext bundleContext;
    ErrorDialog dialog;
    @Inject
    private IEclipseContext context;

    public void report(IStatus status, int style, Object ... information) {
        int action = style & 0xF0;
        if (action == 0) {
            action = status.matches(4) ? 64 : 32;
        }
        if (style != 16) {
            this.log(status);
            if ((action & 0xC0) != 0) {
                boolean shouldBlock = (action & 0x80) != 0;
                this.openDialog(status, shouldBlock, information);
            }
        }
    }

    private void log(IStatus status) {
        if (status.matches(4)) {
            this.logger.error(status.getException(), status.getMessage());
        } else if (status.matches(2)) {
            this.logger.warn(status.getException(), status.getMessage());
        } else if (status.matches(1)) {
            this.logger.info(status.getException(), status.getMessage());
        }
    }

    private void openDialog(IStatus status, boolean shouldBlock, Object ... information) {
        String[] informationStrings = new String[information.length];
        if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
            this.log(status);
            return;
        }
        Status exceptionStatus = new Status(status.getSeverity(), status.getPlugin(), status.getException() == null ? status.getMessage() : status.getException().toString(), status.getException());
        Shell myShell = null;
        if (this.shellProvider != null) {
            myShell = this.shellProvider.getShell();
        } else {
            IShellProvider provider;
            IEclipseContext activeLeaf = this.context.getActiveLeaf();
            if (activeLeaf != null && (provider = (IShellProvider)activeLeaf.get(IShellProvider.class)) != null) {
                myShell = provider.getShell();
            }
        }
        if (myShell == null) {
            myShell = new Shell();
        }
        this.dialog = new ErrorDialog(myShell, WorkbenchSWTMessages.InternalError, status.getMessage(), (IStatus)(status.getException() != null ? exceptionStatus : status), 7){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setBackgroundMode(1);
            }
        };
        int i = 0;
        while (i < information.length) {
            informationStrings[i] = information[i] == null ? "null" : information[i].toString();
            ++i;
        }
        this.dialog.setBlockOnOpen(shouldBlock);
        this.dialog.open();
    }

    public IStatus newStatus(int severity, String message, Throwable exception) {
        return new Status(severity, this.getPluginId(), message, exception);
    }

    protected String getPluginId() {
        return this.bundleContext == null ? "unknown" : this.bundleContext.getBundle().getSymbolicName();
    }
}

