/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;

public class ContextListenerTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<EventListener, ListenerRegistration> {
    public ContextListenerTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime, contextController);
    }

    public AtomicReference<ListenerRegistration> addingService(ServiceReference<EventListener> serviceReference) {
        AtomicReference<ListenerRegistration> result = new AtomicReference<ListenerRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            this.contextController.checkShutdown();
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + String.valueOf(serviceReference), 1);
                }
                AtomicReference<ListenerRegistration> atomicReference = result;
                return atomicReference;
            }
            this.httpServiceRuntime.removeFailedListenerDTO(serviceReference);
            Object listenerObj = serviceReference.getProperty("osgi.http.whiteboard.listener");
            if (!(listenerObj instanceof Boolean || "true".equalsIgnoreCase(String.valueOf(listenerObj)) || "false".equalsIgnoreCase(String.valueOf(listenerObj)) || "1".equalsIgnoreCase(String.valueOf(listenerObj)) || "0".equalsIgnoreCase(String.valueOf(listenerObj)) || "yes".equalsIgnoreCase(String.valueOf(listenerObj)) || "no".equalsIgnoreCase(String.valueOf(listenerObj)))) {
                throw new HttpWhiteboardFailureException("osgi.http.whiteboard.listener=" + String.valueOf(listenerObj) + " is not a valid option. Ignoring!", 6);
            }
            if (Boolean.FALSE.equals(listenerObj) || "false".equalsIgnoreCase(String.valueOf(listenerObj)) || "0".equalsIgnoreCase(String.valueOf(listenerObj)) || "no".equalsIgnoreCase(String.valueOf(listenerObj))) {
                AtomicReference<ListenerRegistration> atomicReference = result;
                return atomicReference;
            }
            try {
                result.set(this.contextController.addListenerRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
            }
            catch (Throwable t) {
                this.httpServiceRuntime.error(t.getMessage(), t);
                this.recordFailed(serviceReference, 4);
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    @Override
    void removeFailed(ServiceReference<EventListener> serviceReference) {
        this.contextController.getHttpServiceRuntime().removeFailedListenerDTO(serviceReference);
    }

    private void recordFailed(ServiceReference<EventListener> serviceReference, int failureReason) {
        FailedListenerDTO failedListenerDTO = new FailedListenerDTO();
        failedListenerDTO.failureReason = failureReason;
        failedListenerDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedListenerDTO.servletContextId = this.contextController.getServiceId();
        failedListenerDTO.types = StringPlus.from(serviceReference.getProperty("objectClass")).toArray(new String[0]);
        this.contextController.getHttpServiceRuntime().recordFailedListenerDTO(serviceReference, failedListenerDTO);
    }
}

