/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayOperationHandler
extends AbstractOperationHandler {
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_CURSOR_LOCATION = "cursorLocation";
    private static final String PROP_FOCUS_CONTROL = "focusControl";
    private final Display display;

    public DisplayOperationHandler(Display display) {
        this.display = display;
    }

    @Override
    public void handleSet(JsonObject properties) {
        this.handleSetBounds(this.display, properties);
        this.handleSetCursorLocation(this.display, properties);
        this.handleSetFocusControl(this.display, properties);
    }

    @Override
    public void handleNotify(String eventName, JsonObject properties) {
        if ("Resize".equals(eventName)) {
            this.handleNotifyResize(this.display);
        }
    }

    public void handleSetBounds(Display display, JsonObject properties) {
        JsonValue value = properties.get(PROP_BOUNDS);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            Rectangle bounds = new Rectangle(arrayValue.get(0).asInt(), arrayValue.get(1).asInt(), arrayValue.get(2).asInt(), arrayValue.get(3).asInt());
            DisplayOperationHandler.getDisplayAdapter(display).setBounds(bounds);
        }
    }

    public void handleSetCursorLocation(Display display, JsonObject properties) {
        JsonValue value = properties.get(PROP_CURSOR_LOCATION);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            Point location = new Point(arrayValue.get(0).asInt(), arrayValue.get(1).asInt());
            DisplayOperationHandler.getDisplayAdapter(display).setCursorLocation(location.x, location.y);
        }
    }

    public void handleSetFocusControl(Display display, JsonObject properties) {
        JsonValue value = properties.get(PROP_FOCUS_CONTROL);
        if (value != null && !value.isNull()) {
            String id = value.asString();
            Control focusControl = null;
            Shell[] shells = DisplayOperationHandler.getDisplayAdapter(display).getShells();
            int i = 0;
            while (focusControl == null && i < shells.length) {
                Widget widget = WidgetUtil.find(shells[i], id);
                if (widget instanceof Control) {
                    focusControl = (Control)widget;
                }
                ++i;
            }
            if (focusControl != null && EventUtil.isAccessible(focusControl)) {
                DisplayOperationHandler.getDisplayAdapter(display).setFocusControl(focusControl, false);
            }
        }
    }

    public void handleNotifyResize(Display display) {
        Event event = new Event();
        event.display = display;
        event.type = 11;
        event.time = EventUtil.getLastEventTime();
        event.setBounds(display.getBounds());
        DisplayOperationHandler.getDisplayAdapter(display).notifyListeners(11, event);
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        return display.getAdapter(IDisplayAdapter.class);
    }
}

