/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.template;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.template.Cell;
import org.eclipse.rap.rwt.template.Template;
import org.eclipse.swt.graphics.Image;

public class ImageCell
extends Cell<ImageCell> {
    private static final String TYPE_IMAGE = "image";
    private static final String PROPERTY_IMAGE = "image";
    private static final String PROPERTY_SCALE_MODE = "scaleMode";
    private Image image;
    private ScaleMode scaleMode;

    public ImageCell(Template template) {
        super(template, "image");
    }

    public ImageCell setImage(Image image) {
        this.image = image;
        return this;
    }

    Image getImage() {
        return this.image;
    }

    public ImageCell setScaleMode(ScaleMode scaleMode) {
        ParamCheck.notNull((Object)scaleMode, PROPERTY_SCALE_MODE);
        this.scaleMode = scaleMode;
        return this;
    }

    ScaleMode getScaleMode() {
        return this.scaleMode;
    }

    @Override
    protected JsonObject toJson() {
        JsonObject json = super.toJson();
        if (this.image != null) {
            json.add("image", JsonMapping.toJson(this.image));
        }
        if (this.scaleMode != null) {
            json.add(PROPERTY_SCALE_MODE, this.scaleMode.name());
        }
        return json;
    }

    public static enum ScaleMode {
        NONE,
        FIT,
        FILL,
        STRETCH;

    }
}

