/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogUtil {
    public static void openInformation(Shell parent, String title, String message, DialogCallback callback) {
        MessageDialogUtil.open(2, parent, title, message, callback);
    }

    public static void openError(Shell parent, String title, String message, DialogCallback callback) {
        MessageDialogUtil.open(1, parent, title, message, callback);
    }

    public static void openQuestion(Shell parent, String title, String message, DialogCallback callback) {
        MessageDialogUtil.open(3, parent, title, message, callback);
    }

    public static void openConfirm(Shell parent, String title, String message, DialogCallback callback) {
        MessageDialogUtil.open(5, parent, title, message, callback);
    }

    public static void openWarning(Shell parent, String title, String message, DialogCallback callback) {
        MessageDialogUtil.open(4, parent, title, message, callback);
    }

    private static void open(int kind, Shell parent, String title, String message, final DialogCallback callback) {
        String[] buttonLabels = MessageDialogUtil.getButtonLabels(kind);
        MessageDialog dialog = new MessageDialog(parent, title, null, message, kind, buttonLabels, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }

            public boolean close() {
                boolean result = super.close();
                if (callback != null) {
                    callback.dialogClosed(this.getReturnCode());
                }
                return result;
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    private static String[] getButtonLabels(int kind) {
        return switch (kind) {
            case 1, 2, 4 -> new String[]{IDialogConstants.get().OK_LABEL};
            case 5 -> new String[]{IDialogConstants.get().OK_LABEL, IDialogConstants.get().CANCEL_LABEL};
            case 3 -> new String[]{IDialogConstants.get().YES_LABEL, IDialogConstants.get().NO_LABEL};
            case 6 -> new String[]{IDialogConstants.get().YES_LABEL, IDialogConstants.get().NO_LABEL, IDialogConstants.get().CANCEL_LABEL};
            default -> throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
        };
    }
}

