/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.functions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.rap.e4.apache.jxpath.ExpressionContext;
import org.eclipse.rap.e4.apache.jxpath.Function;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidAccessException;
import org.eclipse.rap.e4.apache.jxpath.util.TypeUtils;
import org.eclipse.rap.e4.apache.jxpath.util.ValueUtils;

public class MethodFunction
implements Function {
    private Method method;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public MethodFunction(Method method) {
        this.method = ValueUtils.getAccessibleMethod(method);
    }

    @Override
    public Object invoke(ExpressionContext context, Object[] parameters) {
        try {
            Object[] args;
            Object target;
            if (Modifier.isStatic(this.method.getModifiers())) {
                target = null;
                if (parameters == null) {
                    parameters = EMPTY_ARRAY;
                }
                int pi = 0;
                Class<?>[] types = this.method.getParameterTypes();
                if (types.length >= 1 && ExpressionContext.class.isAssignableFrom(types[0])) {
                    pi = 1;
                }
                args = new Object[parameters.length + pi];
                if (pi == 1) {
                    args[0] = context;
                }
                int i = 0;
                while (i < parameters.length) {
                    args[i + pi] = TypeUtils.convert(parameters[i], types[i + pi]);
                    ++i;
                }
            } else {
                int pi = 0;
                Class<?>[] types = this.method.getParameterTypes();
                if (types.length >= 1 && ExpressionContext.class.isAssignableFrom(types[0])) {
                    pi = 1;
                }
                target = TypeUtils.convert(parameters[0], this.method.getDeclaringClass());
                args = new Object[parameters.length - 1 + pi];
                if (pi == 1) {
                    args[0] = context;
                }
                int i = 1;
                while (i < parameters.length) {
                    args[pi + i - 1] = TypeUtils.convert(parameters[i], types[i + pi - 1]);
                    ++i;
                }
            }
            return this.method.invoke(target, args);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            throw new JXPathInvalidAccessException("Cannot invoke " + this.method, ex);
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

