/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.compiler;

import org.eclipse.rap.e4.apache.jxpath.Pointer;
import org.eclipse.rap.e4.apache.jxpath.ri.EvalContext;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.AncestorContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.AttributeContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.ChildContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.DescendantContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.InitialContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.NamespaceContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.ParentContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.PrecedingOrFollowingContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.PredicateContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.SelfContext;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.SimplePathInterpreter;
import org.eclipse.rap.e4.apache.jxpath.ri.axes.UnionContext;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Expression;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NameAttributeTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeNameTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeTypeTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.Step;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public abstract class Path
extends Expression {
    private Step[] steps;
    private boolean basicKnown = false;
    private boolean basic;

    public Path(Step[] steps) {
        this.steps = steps;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    @Override
    public boolean computeContextDependent() {
        if (this.steps != null) {
            int i = 0;
            while (i < this.steps.length) {
                if (this.steps[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public synchronized boolean isSimplePath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = true;
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                if (!this.isSimpleStep(steps[i])) {
                    this.basic = false;
                    break;
                }
                ++i;
            }
        }
        return this.basic;
    }

    protected boolean isSimpleStep(Step step) {
        if (step.getAxis() == 1) {
            NodeTest nodeTest = step.getNodeTest();
            if (!(nodeTest instanceof NodeTypeTest)) {
                return false;
            }
            int nodeType = ((NodeTypeTest)nodeTest).getNodeType();
            if (nodeType != 1) {
                return false;
            }
            return this.areBasicPredicates(step.getPredicates());
        }
        if (step.getAxis() == 2 || step.getAxis() == 5) {
            NodeTest nodeTest = step.getNodeTest();
            if (!(nodeTest instanceof NodeNameTest)) {
                return false;
            }
            if (((NodeNameTest)nodeTest).isWildcard()) {
                return false;
            }
            return this.areBasicPredicates(step.getPredicates());
        }
        return false;
    }

    protected boolean areBasicPredicates(Expression[] predicates) {
        if (predicates != null && predicates.length != 0) {
            boolean firstIndex = true;
            int i = 0;
            while (i < predicates.length) {
                if (predicates[i] instanceof NameAttributeTest) {
                    if (((NameAttributeTest)predicates[i]).getNameTestExpression().isContextDependent()) {
                        return false;
                    }
                } else {
                    if (predicates[i].isContextDependent()) {
                        return false;
                    }
                    if (!firstIndex) {
                        return false;
                    }
                    firstIndex = false;
                }
                ++i;
            }
        }
        return true;
    }

    protected Pointer getSingleNodePointerForSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context.getSingleNodePointer();
        }
        if (this.isSimplePath()) {
            NodePointer ptr = (NodePointer)context.getSingleNodePointer();
            return SimplePathInterpreter.interpretSimpleLocationPath(context, ptr, this.steps);
        }
        return this.searchForPath(context);
    }

    protected Pointer searchForPath(EvalContext context) {
        EvalContext ctx = this.buildContextChain(context, this.steps.length, true);
        Pointer pointer = ctx.getSingleNodePointer();
        if (pointer != null) {
            return pointer;
        }
        int i = this.steps.length;
        while (--i > 0) {
            if (!this.isSimpleStep(this.steps[i])) {
                return null;
            }
            ctx = this.buildContextChain(context, i, true);
            if (!ctx.hasNext()) continue;
            Pointer partial = (Pointer)ctx.next();
            if (ctx.hasNext()) {
                return null;
            }
            if (!(partial instanceof NodePointer)) continue;
            return SimplePathInterpreter.createNullPointer(context, (NodePointer)partial, this.steps, i);
        }
        return null;
    }

    protected EvalContext evalSteps(EvalContext context) {
        return this.buildContextChain(context, this.steps.length, false);
    }

    protected EvalContext buildContextChain(EvalContext context, int stepCount, boolean createInitialContext) {
        if (createInitialContext) {
            context = new InitialContext(context);
        }
        if (this.steps.length == 0) {
            return context;
        }
        int i = 0;
        while (i < stepCount) {
            context = this.createContextForStep(context, this.steps[i].getAxis(), this.steps[i].getNodeTest());
            Expression[] predicates = this.steps[i].getPredicates();
            if (predicates != null) {
                int j = 0;
                while (j < predicates.length) {
                    if (j != 0) {
                        context = new UnionContext(context, new EvalContext[]{context});
                    }
                    context = new PredicateContext(context, predicates[j]);
                    ++j;
                }
            }
            ++i;
        }
        return context;
    }

    protected EvalContext createContextForStep(EvalContext context, int axis, NodeTest nodeTest) {
        QName qname;
        String prefix;
        if (nodeTest instanceof NodeNameTest && (prefix = (qname = ((NodeNameTest)nodeTest).getNodeName()).getPrefix()) != null) {
            String namespaceURI = context.getJXPathContext().getNamespaceURI(prefix);
            nodeTest = new NodeNameTest(qname, namespaceURI);
        }
        switch (axis) {
            case 4: {
                return new AncestorContext(context, false, nodeTest);
            }
            case 10: {
                return new AncestorContext(context, true, nodeTest);
            }
            case 5: {
                return new AttributeContext(context, nodeTest);
            }
            case 2: {
                return new ChildContext(context, nodeTest, false, false);
            }
            case 9: {
                return new DescendantContext(context, false, nodeTest);
            }
            case 13: {
                return new DescendantContext(context, true, nodeTest);
            }
            case 8: {
                return new PrecedingOrFollowingContext(context, nodeTest, false);
            }
            case 11: {
                return new ChildContext(context, nodeTest, true, false);
            }
            case 6: {
                return new NamespaceContext(context, nodeTest);
            }
            case 3: {
                return new ParentContext(context, nodeTest);
            }
            case 7: {
                return new PrecedingOrFollowingContext(context, nodeTest, true);
            }
            case 12: {
                return new ChildContext(context, nodeTest, true, true);
            }
            case 1: {
                return new SelfContext(context, nodeTest);
            }
        }
        return null;
    }
}

