/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rap.demo.controls.CheckWidgetCellEditor;
import org.eclipse.rap.demo.controls.CheckboxEditingSupport;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

public class CheckboxTableViewerColumn {
    private final TableViewer tableViewer;
    private final TableViewerColumn tableViewerColumn;
    private final int columnIndex;
    private final ColumnViewerEditorActivationListener editorActivationListener;
    private final CheckboxColumnLabelProvider checkboxLabelProvider;
    private final CheckboxColumnEditingSupport checkboxEditingSupport;
    private ILabelProvider labelProviderDelegate;
    private CheckboxEditingSupport editingSupportDelegate;
    private ColumnViewerEditor editor;
    private boolean editing;

    public CheckboxTableViewerColumn(TableViewer tableViewer, int columnStyle) {
        this.tableViewer = tableViewer;
        this.checkboxLabelProvider = new CheckboxColumnLabelProvider();
        this.checkboxEditingSupport = new CheckboxColumnEditingSupport();
        this.editorActivationListener = new CheckboxEditorActivationListener();
        this.tableViewerColumn = this.createViewerColumn(columnStyle);
        this.columnIndex = this.computeColumnIndex();
        this.registerDisposeListener();
    }

    public TableColumn getColumn() {
        return this.tableViewerColumn.getColumn();
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProviderDelegate = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProviderDelegate;
    }

    public void setEditingSupport(CheckboxEditingSupport editingSupport) {
        this.editingSupportDelegate = editingSupport;
    }

    public CheckboxEditingSupport getEditingSupport() {
        return this.editingSupportDelegate;
    }

    public void attachToEditor() {
        this.editor = this.tableViewer.getColumnViewerEditor();
        this.editor.addEditorActivationListener(this.editorActivationListener);
    }

    private TableViewerColumn createViewerColumn(int columnStyle) {
        TableViewerColumn result = new TableViewerColumn(this.tableViewer, columnStyle);
        result.setLabelProvider((CellLabelProvider)this.checkboxLabelProvider);
        result.setEditingSupport((EditingSupport)this.checkboxEditingSupport);
        return result;
    }

    private int computeColumnIndex() {
        return this.getColumn().getParent().indexOf(this.getColumn());
    }

    private void registerDisposeListener() {
        this.getColumn().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CheckboxTableViewerColumn.this.dispose();
            }
        });
    }

    private void dispose() {
        if (this.editor != null) {
            this.editor.removeEditorActivationListener(this.editorActivationListener);
        }
        this.checkboxLabelProvider.dispose();
        if (this.labelProviderDelegate != null) {
            this.labelProviderDelegate.dispose();
        }
    }

    private static class CellEditorAdapter
    implements ICellEditorListener {
        private CellEditorAdapter() {
        }

        public void applyEditorValue() {
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }
    }

    private class CheckboxColumnEditingSupport
    extends EditingSupport {
        CheckboxColumnEditingSupport() {
            super((ColumnViewer)CheckboxTableViewerColumn.this.tableViewer);
        }

        protected void setValue(Object element, Object value) {
            CheckboxTableViewerColumn.this.editingSupportDelegate.setValue(element, (Boolean)value);
            CheckboxTableViewerColumn.this.tableViewer.refresh(element);
        }

        protected Object getValue(Object element) {
            return CheckboxTableViewerColumn.this.editingSupportDelegate.getValue(element);
        }

        protected CellEditor getCellEditor(final Object element) {
            CheckWidgetCellEditor cellEditor = new CheckWidgetCellEditor((Composite)CheckboxTableViewerColumn.this.getColumn().getParent());
            cellEditor.addListener(new CellEditorAdapter(){

                @Override
                public void cancelEditor() {
                    ((CheckboxColumnEditingSupport)CheckboxColumnEditingSupport.this).CheckboxTableViewerColumn.this.tableViewer.refresh(element);
                }
            });
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return CheckboxTableViewerColumn.this.editingSupportDelegate != null && CheckboxTableViewerColumn.this.editingSupportDelegate.canEdit(element);
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            cell.setImage(null);
            super.initializeCellEditorValue(cellEditor, cell);
        }
    }

    private class CheckboxColumnLabelProvider
    extends ColumnLabelProvider {
        private CheckboxColumnLabelProvider() {
        }

        public String getText(Object element) {
            String result = "";
            if (!CheckboxTableViewerColumn.this.editing) {
                result = CheckboxTableViewerColumn.this.labelProviderDelegate.getText(element);
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            if (!CheckboxTableViewerColumn.this.editing) {
                result = CheckboxTableViewerColumn.this.labelProviderDelegate.getImage(element);
            }
            return result;
        }
    }

    private class CheckboxEditorActivationListener
    extends ColumnViewerEditorActivationListener {
        private CheckboxEditorActivationListener() {
        }

        public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            ViewerCell cell = (ViewerCell)event.getSource();
            if (cell.getColumnIndex() == CheckboxTableViewerColumn.this.columnIndex) {
                CheckboxTableViewerColumn.this.editing = true;
            }
        }

        public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            ViewerCell cell = (ViewerCell)event.getSource();
            if (cell.getColumnIndex() == CheckboxTableViewerColumn.this.columnIndex) {
                CheckboxTableViewerColumn.this.editing = false;
            }
        }

        public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
        }
    }
}

