/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class QuickAccessEntry {
    boolean firstInCategory;
    boolean lastInCategory;
    QuickAccessElement element;
    QuickAccessProvider provider;
    int[][] elementMatchRegions;
    int[][] providerMatchRegions;
    private int matchQuality;
    public static final int MATCH_PERFECT = 0;
    public static final int MATCH_EXCELLENT = 5;
    public static final int MATCH_GOOD = 10;
    public static final int MATCH_PARTIAL = 15;

    public QuickAccessEntry(QuickAccessElement element, QuickAccessProvider provider, int[][] elementMatchRegions, int[][] providerMatchRegions, int matchQuality) {
        this.element = element;
        this.provider = provider;
        this.elementMatchRegions = elementMatchRegions;
        this.providerMatchRegions = providerMatchRegions;
        this.matchQuality = matchQuality;
    }

    Image getImage(QuickAccessElement element, ResourceManager resourceManager) {
        Image image = this.findOrCreateImage(element.getImageDescriptor(), resourceManager);
        if (image == null) {
            image = WorkbenchImages.getImage("IMG_OBJ_ELEMENT");
        }
        return image;
    }

    private Image findOrCreateImage(ImageDescriptor imageDescriptor, ResourceManager resourceManager) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)resourceManager.find((DeviceResourceDescriptor)imageDescriptor);
        if (image == null) {
            try {
                image = resourceManager.createImage(imageDescriptor);
            }
            catch (DeviceResourceException e) {
                WorkbenchPlugin.log(e);
            }
        }
        return image;
    }

    public void erase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }

    public int getMatchQuality() {
        return this.matchQuality;
    }
}

