/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public class Diffs {
    public static <E> ListDiff<E> unmodifiableDiff(ListDiff<? extends E> diff) {
        if (diff instanceof UnmodifiableListDiff) {
            return diff;
        }
        return new UnmodifiableListDiff<E>(diff);
    }

    public static <E> SetDiff<E> unmodifiableDiff(SetDiff<? extends E> diff) {
        if (diff instanceof UnmodifiableSetDiff) {
            return diff;
        }
        return new UnmodifiableSetDiff<E>(diff);
    }

    public static <K, V> MapDiff<K, V> unmodifiableDiff(MapDiff<? extends K, ? extends V> diff) {
        if (diff instanceof UnmodifiableMapDiff) {
            return diff;
        }
        return new UnmodifiableMapDiff<K, V>(diff);
    }

    public static <V> ValueDiff<V> unmodifiableDiff(ValueDiff<? extends V> diff) {
        if (diff instanceof UnmodifiableValueDiff) {
            return diff;
        }
        return new UnmodifiableValueDiff<V>(diff);
    }

    public static <E> ListDiff<E> computeListDiff(List<? extends E> oldList, List<? extends E> newList) {
        ArrayList<ListDiffEntry<E>> diffEntries = new ArrayList<ListDiffEntry<E>>();
        Diffs.createListDiffs(new ArrayList<E>(oldList), newList, diffEntries);
        return Diffs.createListDiff(diffEntries);
    }

    public static <E> ListDiff<E> computeLazyListDiff(final List<? extends E> oldList, final List<? extends E> newList) {
        return new ListDiff<E>(){
            ListDiff<E> lazyDiff;

            @Override
            public ListDiffEntry<E>[] getDifferences() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeListDiff(oldList, newList);
                }
                return this.lazyDiff.getDifferences();
            }
        };
    }

    private static <E> void createListDiffs(List<E> oldList, List<? extends E> newList, List<ListDiffEntry<E>> listDiffs) {
        int index = 0;
        for (E newValue : newList) {
            if (oldList.size() <= index) {
                listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
            } else {
                boolean done;
                do {
                    done = true;
                    E oldValue = oldList.get(index);
                    if (!(oldValue == null ? newValue != null : !oldValue.equals(newValue))) continue;
                    int oldIndexOfNewValue = Diffs.listIndexOf(oldList, newValue, index);
                    if (oldIndexOfNewValue != -1) {
                        int newIndexOfOldValue = Diffs.listIndexOf(newList, oldValue, index);
                        if (newIndexOfOldValue == -1) {
                            listDiffs.add(Diffs.createListDiffEntry(index, false, oldValue));
                            oldList.remove(index);
                            done = false;
                            continue;
                        }
                        if (newIndexOfOldValue > oldIndexOfNewValue) {
                            if (oldList.size() <= newIndexOfOldValue) {
                                newIndexOfOldValue = oldList.size() - 1;
                            }
                            listDiffs.add(Diffs.createListDiffEntry(index, false, oldValue));
                            oldList.remove(index);
                            listDiffs.add(Diffs.createListDiffEntry(newIndexOfOldValue, true, oldValue));
                            oldList.add(newIndexOfOldValue, oldValue);
                            done = false;
                            continue;
                        }
                        listDiffs.add(Diffs.createListDiffEntry(oldIndexOfNewValue, false, newValue));
                        oldList.remove(oldIndexOfNewValue);
                        listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
                        oldList.add(index, newValue);
                        continue;
                    }
                    oldList.add(index, newValue);
                    listDiffs.add(Diffs.createListDiffEntry(index, true, newValue));
                } while (!done);
            }
            ++index;
        }
        int i = oldList.size();
        while (i > index) {
            listDiffs.add(Diffs.createListDiffEntry(--i, false, oldList.get(i)));
        }
    }

    private static <E> int listIndexOf(List<E> list, Object object, int index) {
        int size = list.size();
        int i = index;
        while (i < size) {
            E candidate = list.get(i);
            if (candidate == null ? object == null : candidate.equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public static final boolean equals(Object left, Object right) {
        return Objects.equals(left, right);
    }

    public static <E> SetDiff<E> computeSetDiff(Set<? extends E> oldSet, Set<? extends E> newSet) {
        HashSet<E> additions = new HashSet<E>(newSet);
        additions.removeAll(oldSet);
        HashSet<E> removals = new HashSet<E>(oldSet);
        removals.removeAll(newSet);
        return Diffs.createSetDiff(additions, removals);
    }

    public static <E> SetDiff<E> computeLazySetDiff(final Set<? extends E> oldSet, final Set<? extends E> newSet) {
        return new SetDiff<E>(){
            private SetDiff<E> lazyDiff;

            private SetDiff<E> getLazyDiff() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeSetDiff(oldSet, newSet);
                }
                return this.lazyDiff;
            }

            @Override
            public Set<E> getAdditions() {
                return this.getLazyDiff().getAdditions();
            }

            @Override
            public Set<E> getRemovals() {
                return this.getLazyDiff().getRemovals();
            }
        };
    }

    public static <K, V> MapDiff<K, V> computeMapDiff(Map<? extends K, ? extends V> oldMap, Map<? extends K, ? extends V> newMap) {
        final HashSet<K> addedKeys = new HashSet<K>(newMap.keySet());
        final HashSet<K> removedKeys = new HashSet<K>();
        final HashSet<K> changedKeys = new HashSet<K>();
        final HashMap<K, V> oldValues = new HashMap<K, V>();
        final HashMap<Object, V> newValues = new HashMap<Object, V>();
        for (Map.Entry<K, V> oldEntry : oldMap.entrySet()) {
            K oldKey = oldEntry.getKey();
            if (addedKeys.remove(oldKey)) {
                V newValue;
                V oldValue = oldEntry.getValue();
                if (Objects.equals(oldValue, newValue = newMap.get(oldKey))) continue;
                changedKeys.add(oldKey);
                oldValues.put(oldKey, oldValue);
                newValues.put(oldKey, newValue);
                continue;
            }
            removedKeys.add(oldKey);
            oldValues.put(oldKey, oldEntry.getValue());
        }
        for (Object newKey : addedKeys) {
            newValues.put(newKey, newMap.get(newKey));
        }
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return addedKeys;
            }

            @Override
            public Set<K> getChangedKeys() {
                return changedKeys;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return removedKeys;
            }

            @Override
            public V getNewValue(Object key) {
                return newValues.get(key);
            }

            @Override
            public V getOldValue(Object key) {
                return oldValues.get(key);
            }
        };
    }

    public static <K, V> MapDiff<K, V> computeLazyMapDiff(final Map<? extends K, ? extends V> oldMap, final Map<? extends K, ? extends V> newMap) {
        return new MapDiff<K, V>(){
            private MapDiff<K, V> lazyDiff;

            private MapDiff<K, V> getLazyDiff() {
                if (this.lazyDiff == null) {
                    this.lazyDiff = Diffs.computeMapDiff(oldMap, newMap);
                }
                return this.lazyDiff;
            }

            @Override
            public Set<K> getAddedKeys() {
                return this.getLazyDiff().getAddedKeys();
            }

            @Override
            public Set<K> getRemovedKeys() {
                return this.getLazyDiff().getRemovedKeys();
            }

            @Override
            public Set<K> getChangedKeys() {
                return this.getLazyDiff().getChangedKeys();
            }

            @Override
            public V getOldValue(Object key) {
                return this.getLazyDiff().getOldValue(key);
            }

            @Override
            public V getNewValue(Object key) {
                return this.getLazyDiff().getNewValue(key);
            }
        };
    }

    public static <T> ValueDiff<T> createValueDiff(final T oldValue, final T newValue) {
        return new ValueDiff<T>(){

            @Override
            public T getOldValue() {
                return oldValue;
            }

            @Override
            public T getNewValue() {
                return newValue;
            }
        };
    }

    public static <E> SetDiff<E> createSetDiff(Set<? extends E> additions, Set<? extends E> removals) {
        final Set<? extends E> unmodifiableAdditions = Collections.unmodifiableSet(additions);
        final Set<? extends E> unmodifiableRemovals = Collections.unmodifiableSet(removals);
        return new SetDiff<E>(){

            @Override
            public Set<E> getAdditions() {
                return unmodifiableAdditions;
            }

            @Override
            public Set<E> getRemovals() {
                return unmodifiableRemovals;
            }
        };
    }

    public static <E> ListDiff<E> createListDiff(ListDiffEntry<E> difference) {
        return Diffs.createListDiff(Collections.singletonList(difference));
    }

    public static <E> ListDiff<E> createListDiff(ListDiffEntry<E> difference1, ListDiffEntry<E> difference2) {
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> differences = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(2);
        differences.add(difference1);
        differences.add(difference2);
        return Diffs.createListDiff(differences);
    }

    @SafeVarargs
    public static <E> ListDiff<E> createListDiff(final ListDiffEntry<E> ... differences) {
        return new ListDiff<E>(){

            @Override
            public ListDiffEntry<E>[] getDifferences() {
                return differences;
            }
        };
    }

    public static <E> ListDiff<E> createListDiff(List<ListDiffEntry<E>> differences) {
        final ListDiffEntry[] differencesArray = differences.toArray(new ListDiffEntry[differences.size()]);
        return new ListDiff<E>(){

            @Override
            public ListDiffEntry<E>[] getDifferences() {
                return differencesArray;
            }
        };
    }

    public static <E> ListDiffEntry<E> createListDiffEntry(final int position, final boolean isAddition, final E element) {
        return new ListDiffEntry<E>(){

            @Override
            public int getPosition() {
                return position;
            }

            @Override
            public boolean isAddition() {
                return isAddition;
            }

            @Override
            public E getElement() {
                return element;
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleAdd(final K addedKey, final V newValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.singleton(addedKey);
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return newValue;
            }

            @Override
            public V getOldValue(Object key) {
                return null;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.emptySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleChange(final K existingKey, final V oldValue, final V newValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.singleton(existingKey);
            }

            @Override
            public V getNewValue(Object key) {
                return newValue;
            }

            @Override
            public V getOldValue(Object key) {
                return oldValue;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.emptySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffSingleRemove(final K removedKey, final V oldValue) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return null;
            }

            @Override
            public V getOldValue(Object key) {
                return oldValue;
            }

            @Override
            public Set<K> getRemovedKeys() {
                return Collections.singleton(removedKey);
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiffRemoveAll(final Map<K, V> copyOfOldMap) {
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            @Override
            public Set<K> getChangedKeys() {
                return Collections.emptySet();
            }

            @Override
            public V getNewValue(Object key) {
                return null;
            }

            @Override
            public V getOldValue(Object key) {
                return copyOfOldMap.get(key);
            }

            @Override
            public Set<K> getRemovedKeys() {
                return copyOfOldMap.keySet();
            }
        };
    }

    public static <K, V> MapDiff<K, V> createMapDiff(Set<? extends K> addedKeys, Set<? extends K> removedKeys, Set<? extends K> changedKeys, final Map<? extends K, ? extends V> oldValues, final Map<? extends K, ? extends V> newValues) {
        final Set<? extends K> finalAddedKeys = Collections.unmodifiableSet(addedKeys);
        final Set<? extends K> finalRemovedKeys = Collections.unmodifiableSet(removedKeys);
        final Set<? extends K> finalChangedKeys = Collections.unmodifiableSet(changedKeys);
        return new MapDiff<K, V>(){

            @Override
            public Set<K> getAddedKeys() {
                return finalAddedKeys;
            }

            @Override
            public Set<K> getChangedKeys() {
                return finalChangedKeys;
            }

            @Override
            public V getNewValue(Object key) {
                return newValues.get(key);
            }

            @Override
            public V getOldValue(Object key) {
                return oldValues.get(key);
            }

            @Override
            public Set<K> getRemovedKeys() {
                return finalRemovedKeys;
            }
        };
    }

    private static final class UnmodifiableListDiff<E>
    extends ListDiff<E> {
        private final ListDiff<? extends E> toWrap;

        public UnmodifiableListDiff(ListDiff<? extends E> diff) {
            this.toWrap = diff;
        }

        @Override
        public ListDiffEntry<E>[] getDifferences() {
            ListDiffEntry<? extends E>[] original = this.toWrap.getDifferences();
            ListDiffEntry[] result = new ListDiffEntry[original.length];
            System.arraycopy(original, 0, result, 0, original.length);
            return result;
        }
    }

    private static final class UnmodifiableMapDiff<K, V>
    extends MapDiff<K, V> {
        private final MapDiff<? extends K, ? extends V> toWrap;

        public UnmodifiableMapDiff(MapDiff<? extends K, ? extends V> diff) {
            this.toWrap = diff;
        }

        @Override
        public Set<K> getAddedKeys() {
            return Collections.unmodifiableSet(this.toWrap.getAddedKeys());
        }

        @Override
        public Set<K> getRemovedKeys() {
            return Collections.unmodifiableSet(this.toWrap.getRemovedKeys());
        }

        @Override
        public Set<K> getChangedKeys() {
            return Collections.unmodifiableSet(this.toWrap.getChangedKeys());
        }

        @Override
        public V getOldValue(Object key) {
            return this.toWrap.getOldValue(key);
        }

        @Override
        public V getNewValue(Object key) {
            return this.toWrap.getNewValue(key);
        }
    }

    private static final class UnmodifiableSetDiff<E>
    extends SetDiff<E> {
        private final SetDiff<? extends E> toWrap;

        public UnmodifiableSetDiff(SetDiff<? extends E> diff) {
            this.toWrap = diff;
        }

        @Override
        public Set<E> getAdditions() {
            return Collections.unmodifiableSet(this.toWrap.getAdditions());
        }

        @Override
        public Set<E> getRemovals() {
            return Collections.unmodifiableSet(this.toWrap.getRemovals());
        }
    }

    private static final class UnmodifiableValueDiff<E>
    extends ValueDiff<E> {
        private final ValueDiff<? extends E> toWrap;

        public UnmodifiableValueDiff(ValueDiff<? extends E> diff) {
            this.toWrap = diff;
        }

        @Override
        public E getOldValue() {
            return this.toWrap.getOldValue();
        }

        @Override
        public E getNewValue() {
            return this.toWrap.getNewValue();
        }
    }
}

