/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rap.http.servlet.ExtendedHttpService;
import org.eclipse.rap.http.servlet.internal.DefaultServletContextHelper;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.HttpContextHolder;
import org.eclipse.rap.http.servlet.internal.context.WrappedHttpContext;
import org.eclipse.rap.http.servlet.internal.util.Throw;
import org.eclipse.rap.service.http.HttpContext;
import org.eclipse.rap.service.http.HttpService;
import org.eclipse.rap.service.http.NamespaceException;
import org.eclipse.rap.service.servlet.internal.context.ServletContextHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class HttpServiceImpl
implements HttpService,
ExtendedHttpService {
    private static AtomicLong legacyIdGenerator = new AtomicLong(0L);
    final Bundle bundle;
    final HttpServiceRuntimeImpl httpServiceRuntime;
    private volatile boolean shutdown = false;

    public HttpServiceImpl(Bundle bundle, HttpServiceRuntimeImpl httpServiceRuntime) {
        this.bundle = bundle;
        this.httpServiceRuntime = httpServiceRuntime;
    }

    @Override
    public synchronized HttpContext createDefaultHttpContext() {
        this.checkShutdown();
        return new DefaultServletContextHelper(this.bundle);
    }

    @Override
    public synchronized void registerFilter(String alias, Filter filter, Dictionary<String, String> initparams, HttpContext httpContext) {
        this.checkShutdown();
        HttpContextHolder httpContextHolder = this.getHttpContextHolder(httpContext);
        try {
            AccessController.doPrivileged(() -> {
                this.httpServiceRuntime.registerHttpServiceFilter(this.bundle, alias, filter, initparams, httpContextHolder);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throw.unchecked(e.getException());
        }
    }

    private HttpContextHolder getHttpContextHolder(HttpContext httpContext) {
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        this.registerContext(httpContext);
        return (HttpContextHolder)this.httpServiceRuntime.legacyContextMap.get(httpContext);
    }

    @Override
    public synchronized void registerResources(String alias, String name, HttpContext httpContext) {
        this.checkShutdown();
        HttpContextHolder httpContextHolder = this.getHttpContextHolder(httpContext);
        try {
            AccessController.doPrivileged(() -> {
                this.httpServiceRuntime.registerHttpServiceResources(this.bundle, alias, name, httpContextHolder);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throw.unchecked(e.getException());
        }
    }

    @Override
    public synchronized void registerServlet(final String alias, final Servlet servlet, final Dictionary<?, ?> initparams, HttpContext httpContext) {
        this.checkShutdown();
        final HttpContextHolder httpContextHolder = this.getHttpContextHolder(httpContext);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NamespaceException, ServletException {
                    HttpServiceImpl.this.httpServiceRuntime.registerHttpServiceServlet(HttpServiceImpl.this.bundle, alias, servlet, initparams, httpContextHolder);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throw.unchecked(e.getException());
        }
    }

    @Override
    public synchronized void unregister(String alias) {
        this.checkShutdown();
        this.httpServiceRuntime.unregisterHttpServiceAlias(this.bundle, alias);
    }

    @Override
    public synchronized void unregisterFilter(Filter filter) {
        this.checkShutdown();
        this.httpServiceRuntime.unregisterHttpServiceFilter(this.bundle, filter);
    }

    synchronized void shutdown() {
        this.httpServiceRuntime.unregisterHttpServiceObjects(this.bundle);
        this.shutdown = true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Service instance is already shutdown");
        }
    }

    private long generateLegacyId() {
        return legacyIdGenerator.getAndIncrement();
    }

    private HttpContext registerContext(HttpContext httpContext) {
        HttpContextHolder httpContextHolder = (HttpContextHolder)this.httpServiceRuntime.legacyContextMap.get(httpContext);
        if (httpContextHolder == null) {
            String legacyId = httpContext.getClass().getName().replaceAll("[^a-zA-Z_0-9\\-]", "_") + "-" + this.generateLegacyId();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("osgi.http.whiteboard.context.name", legacyId);
            ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/");
            ((Dictionary)props).put("osgi.http.whiteboard.target", this.httpServiceRuntime.getTargetFilter());
            ((Dictionary)props).put("osgi.http.whiteboard.context.httpservice", legacyId);
            ((Dictionary)props).put("equinox.legacy.context.helper", Boolean.TRUE);
            ((Dictionary)props).put("equinox.legacy.http.context.initiating.id", this.bundle.getBundleId());
            ServiceRegistration registration = this.bundle.getBundleContext().registerService(ServletContextHelper.class.getName(), (Object)new WrappedHttpContext(httpContext, this.bundle), props);
            httpContextHolder = new HttpContextHolder(httpContext, (ServiceRegistration<DefaultServletContextHelper>)registration);
            httpContextHolder.incrementUseCount();
            this.httpServiceRuntime.legacyContextMap.put(httpContext, httpContextHolder);
        } else {
            httpContextHolder.incrementUseCount();
        }
        return httpContext;
    }
}

