/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.application;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.ui.internal.application.RAPApplicationContext;

public final class EntryPointApplicationWrapper
implements EntryPoint {
    private static final IApplicationContext context = new RAPApplicationContext();
    private final Class<? extends IApplication> applicationClass;

    public EntryPointApplicationWrapper(Class<? extends IApplication> applicationClass) {
        this.applicationClass = applicationClass;
    }

    public int createUI() {
        int result = 0;
        IApplication application = this.createApplication();
        try {
            Object exitCode = application.start(context);
            if (exitCode instanceof Integer) {
                result = (Integer)exitCode;
            }
        }
        catch (Exception exception) {
            String message = "Exception while executing application " + this.applicationClass.getName();
            throw new RuntimeException(message, exception);
        }
        return result;
    }

    private IApplication createApplication() {
        IApplication application;
        try {
            application = this.applicationClass.newInstance();
        }
        catch (Exception exception) {
            String message = "Failed to create application " + this.applicationClass.getName();
            throw new IllegalArgumentException(message, exception);
        }
        return application;
    }
}

