/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class HostConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(HostConfig.class);
    protected File appBase = null;
    protected File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean deployXML = false;
    protected boolean copyXML = false;
    protected boolean unpackWARs = false;
    protected HashMap<String, DeployedApplication> deployed = new HashMap();
    protected ArrayList<String> serviced = new ArrayList();
    protected static Digester digester = HostConfig.createDigester();
    protected Set<String> invalidWars = new HashSet<String>();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean copyXML) {
        this.copyXML = copyXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("periodic")) {
            this.check();
        }
        try {
            this.host = (Host)event.getLifecycle();
            if (this.host instanceof StandardHost) {
                this.setCopyXML(((StandardHost)this.host).isCopyXML());
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
            }
        }
        catch (ClassCastException e) {
            log.error(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    public synchronized void addServiced(String name) {
        this.serviced.add(name);
    }

    public synchronized boolean isServiced(String name) {
        return this.serviced.contains(name);
    }

    public synchronized void removeServiced(String name) {
        this.serviced.remove(name);
    }

    public long getDeploymentTime(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app == null) {
            return 0L;
        }
        return app.timestamp;
    }

    public boolean isDeployed(String name) {
        DeployedApplication app = this.deployed.get(name);
        return app != null;
    }

    protected static Digester createDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", "org.apache.catalina.core.StandardContext", "className");
        digester.addSetProperties("Context");
        return digester;
    }

    protected File returnCanonicalPath(String path) {
        File file = new File(path);
        File base = new File(System.getProperty("catalina.base"));
        if (!file.isAbsolute()) {
            file = new File(base, path);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        this.appBase = this.returnCanonicalPath(this.host.getAppBase());
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        if (this.host.getXmlBase() != null) {
            this.configBase = this.returnCanonicalPath(this.host.getXmlBase());
        } else {
            StringBuilder xmlDir = new StringBuilder("conf");
            Container parent = this.host.getParent();
            if (parent instanceof Engine) {
                xmlDir.append('/');
                xmlDir.append(parent.getName());
            }
            xmlDir.append('/');
            xmlDir.append(this.host.getName());
            this.configBase = this.returnCanonicalPath(xmlDir.toString());
        }
        return this.configBase;
    }

    public String getConfigBaseName() {
        return this.configBase().getAbsolutePath();
    }

    protected void deployApps() {
        File appBase = this.appBase();
        File configBase = this.configBase();
        String[] filteredAppPaths = this.filterAppPaths(appBase.list());
        this.deployDescriptors(configBase, configBase.list());
        this.deployWARs(appBase, filteredAppPaths);
        this.deployDirectories(appBase, filteredAppPaths);
    }

    protected String[] filterAppPaths(String[] unfilteredAppPaths) {
        Pattern filter = this.host.getDeployIgnorePattern();
        if (filter == null) {
            return unfilteredAppPaths;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        Matcher matcher = null;
        String[] stringArray = unfilteredAppPaths;
        int n = unfilteredAppPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String appPath = stringArray[n2];
            if (matcher == null) {
                matcher = filter.matcher(appPath);
            } else {
                matcher.reset(appPath);
            }
            if (matcher.matches()) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("hostConfig.ignorePath", appPath));
                }
            } else {
                filteredList.add(appPath);
            }
            ++n2;
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    protected void deployApps(String name) {
        File dir;
        File war;
        ContextName cn;
        String baseName;
        File appBase = this.appBase();
        File configBase = this.configBase();
        File xml = new File(configBase, String.valueOf(baseName = (cn = new ContextName(name)).getBaseName()) + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(cn, xml, String.valueOf(baseName) + ".xml");
        }
        if ((war = new File(appBase, String.valueOf(baseName) + ".war")).exists()) {
            this.deployWAR(cn, war, String.valueOf(baseName) + ".war");
        }
        if ((dir = new File(appBase, baseName)).exists()) {
            this.deployDirectory(cn, dir, baseName);
        }
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            ContextName cn;
            String name;
            File contextXml = new File(configBase, files[i]);
            if (files[i].toLowerCase(Locale.ENGLISH).endsWith(".xml") && !this.isServiced(name = (cn = new ContextName(files[i])).getName())) {
                String file = files[i];
                this.deployDescriptor(cn, contextXml, file);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDescriptor(ContextName cn, File contextXml, String file) {
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(cn.getName());
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployDescriptor", file, this.configBase.getPath()));
        }
        Context context = null;
        try {
            Digester digester = HostConfig.digester;
            synchronized (digester) {
                try {
                    context = (Context)HostConfig.digester.parse(contextXml);
                    if (context == null) {
                        log.error(sm.getString("hostConfig.deployDescriptor.error", file));
                        return;
                    }
                }
                finally {
                    HostConfig.digester.reset();
                }
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setConfigFile(contextXml.toURI().toURL());
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            boolean isExternalWar = false;
            boolean isExternal = false;
            if (context.getDocBase() != null) {
                File docBase = new File(context.getDocBase());
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.appBase(), context.getDocBase());
                }
                if (!docBase.getCanonicalPath().startsWith(String.valueOf(this.appBase().getAbsolutePath()) + File.separator)) {
                    isExternal = true;
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                    deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
                    if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        isExternalWar = true;
                    }
                } else {
                    log.warn(sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", docBase));
                    context.setDocBase(null);
                }
            }
            this.host.addChild(context);
            File expandedDocBase = new File(this.appBase(), cn.getBaseName());
            if (context.getDocBase() != null && !(expandedDocBase = new File(context.getDocBase())).isAbsolute()) {
                expandedDocBase = new File(this.appBase(), context.getDocBase());
            }
            if (isExternalWar && this.unpackWARs) {
                deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
            } else {
                File warDocBase;
                if (!isExternal && (warDocBase = new File(String.valueOf(expandedDocBase.getAbsolutePath()) + ".war")).exists()) {
                    deployedApp.redeployResources.put(warDocBase.getAbsolutePath(), warDocBase.lastModified());
                }
                if (expandedDocBase.exists()) {
                    deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApp, null, context);
                }
                if (!isExternal) {
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), contextXml.lastModified());
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("hostConfig.deployDescriptor.error", file), t);
        }
        if (context != null && this.host.findChild(context.getName()) != null) {
            this.deployed.put(context.getName(), deployedApp);
        }
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (!files[i].equalsIgnoreCase("META-INF") && !files[i].equalsIgnoreCase("WEB-INF")) {
                File dir = new File(appBase, files[i]);
                if (files[i].toLowerCase(Locale.ENGLISH).endsWith(".war") && dir.isFile() && !this.invalidWars.contains(files[i])) {
                    ContextName cn = new ContextName(files[i]);
                    if (!this.validateContextPath(appBase, cn.getBaseName())) {
                        log.error(sm.getString("hostConfig.illegalWarName", files[i]));
                        this.invalidWars.add(files[i]);
                    } else if (!this.isServiced(cn.getName())) {
                        String file = files[i];
                        this.deployWAR(cn, dir, file);
                    }
                }
            }
            ++i;
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWAR(ContextName cn, File war, String file) {
        boolean xmlInWar;
        File xml;
        InputStream istream;
        JarEntry entry;
        JarFile jar;
        block76: {
            if (this.deploymentExists(cn.getName())) {
                return;
            }
            jar = null;
            entry = null;
            istream = null;
            FilterOutputStream ostream = null;
            xml = this.copyXML ? new File(this.configBase(), String.valueOf(file.substring(0, file.lastIndexOf("."))) + ".xml") : new File(this.appBase(), String.valueOf(file.substring(0, file.lastIndexOf("."))) + "/META-INF/context.xml");
            xmlInWar = false;
            if (this.deployXML && !xml.exists()) {
                try {
                    try {
                        jar = new JarFile(war);
                        entry = jar.getJarEntry("META-INF/context.xml");
                        if (entry != null) {
                            xmlInWar = true;
                        }
                        if ((this.copyXML || this.unpackWARs) && xmlInWar) {
                            int n;
                            istream = jar.getInputStream(entry);
                            ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                            byte[] buffer = new byte[1024];
                            while ((n = istream.read(buffer)) >= 0) {
                                ((BufferedOutputStream)ostream).write(buffer, 0, n);
                            }
                            ((BufferedOutputStream)ostream).flush();
                            ostream.close();
                            ostream = null;
                            istream.close();
                            istream = null;
                        }
                    }
                    catch (IOException iOException) {
                        if (ostream != null) {
                            try {
                                ostream.close();
                            }
                            catch (Throwable t) {
                                ExceptionUtils.handleThrowable(t);
                            }
                            ostream = null;
                        }
                        if (istream != null) {
                            try {
                                istream.close();
                            }
                            catch (Throwable t) {
                                ExceptionUtils.handleThrowable(t);
                            }
                            istream = null;
                        }
                        entry = null;
                        if (jar == null) break block76;
                        try {
                            jar.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        jar = null;
                        break block76;
                    }
                }
                catch (Throwable throwable) {
                    if (ostream != null) {
                        try {
                            ostream.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        ostream = null;
                    }
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        istream = null;
                    }
                    entry = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        jar = null;
                    }
                    throw throwable;
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                    ostream = null;
                }
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                    istream = null;
                }
                entry = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                    jar = null;
                }
            }
        }
        DeployedApplication deployedApp = new DeployedApplication(cn.getName());
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployWar", file));
        }
        try {
            Digester digester;
            Context context = null;
            if (this.deployXML && xml.exists()) {
                digester = HostConfig.digester;
                synchronized (digester) {
                    try {
                        context = (Context)HostConfig.digester.parse(xml);
                        if (context == null) {
                            log.error(sm.getString("hostConfig.deployDescriptor.error", file));
                            return;
                        }
                    }
                    finally {
                        HostConfig.digester.reset();
                    }
                }
                context.setConfigFile(xml.toURI().toURL());
            } else {
                if (this.deployXML && xmlInWar) {
                    digester = HostConfig.digester;
                    synchronized (digester) {
                        block78: {
                            block79: {
                                try {
                                    jar = new JarFile(war);
                                    entry = jar.getJarEntry("META-INF/context.xml");
                                    istream = jar.getInputStream(entry);
                                    context = (Context)HostConfig.digester.parse(istream);
                                    if (context != null) break block78;
                                    log.error(sm.getString("hostConfig.deployDescriptor.error", file));
                                    if (istream == null) break block79;
                                }
                                catch (Throwable t) {
                                    if (istream != null) {
                                        try {
                                            istream.close();
                                        }
                                        catch (IOException iOException) {}
                                        istream = null;
                                    }
                                    entry = null;
                                    if (jar != null) {
                                        try {
                                            jar.close();
                                        }
                                        catch (IOException iOException) {}
                                        jar = null;
                                    }
                                    HostConfig.digester.reset();
                                    throw t;
                                }
                                try {
                                    istream.close();
                                }
                                catch (IOException iOException) {}
                                istream = null;
                            }
                            entry = null;
                            if (jar != null) {
                                try {
                                    jar.close();
                                }
                                catch (IOException iOException) {}
                                jar = null;
                            }
                            HostConfig.digester.reset();
                            return;
                        }
                        context.setConfigFile(new URL("jar:" + war.toURI().toString() + "!/" + "META-INF/context.xml"));
                        if (istream != null) {
                            try {
                                istream.close();
                            }
                            catch (IOException iOException) {}
                            istream = null;
                        }
                        entry = null;
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException iOException) {}
                            jar = null;
                        }
                        HostConfig.digester.reset();
                    }
                }
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            deployedApp.redeployResources.put(war.getAbsolutePath(), war.lastModified());
            if (this.deployXML && xml.exists() && this.copyXML) {
                deployedApp.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(file);
            this.host.addChild(context);
            if (this.unpackWARs && context.getDocBase() != null) {
                File docBase = new File(this.appBase(), cn.getBaseName());
                deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
                this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
                if (this.deployXML && !this.copyXML && (xmlInWar || xml.exists())) {
                    deployedApp.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                }
            } else {
                this.addWatchedResources(deployedApp, null, context);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("hostConfig.deployWar.error", file), t);
        }
        this.deployed.put(cn.getName(), deployedApp);
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            ContextName cn;
            File dir;
            if (!files[i].equalsIgnoreCase("META-INF") && !files[i].equalsIgnoreCase("WEB-INF") && (dir = new File(appBase, files[i])).isDirectory() && !this.isServiced((cn = new ContextName(files[i])).getName())) {
                this.deployDirectory(cn, dir, files[i]);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDirectory(ContextName cn, File dir, String file) {
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(cn.getName());
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployDir", file));
        }
        try {
            Context context = null;
            File xml = new File(dir, "META-INF/context.xml");
            File xmlCopy = null;
            if (this.deployXML && xml.exists()) {
                Digester digester = HostConfig.digester;
                synchronized (digester) {
                    try {
                        context = (Context)HostConfig.digester.parse(xml);
                        if (context == null) {
                            log.error(sm.getString("hostConfig.deployDescriptor.error", xml));
                            return;
                        }
                    }
                    finally {
                        HostConfig.digester.reset();
                    }
                }
                if (this.copyXML) {
                    xmlCopy = new File(this.configBase(), String.valueOf(file) + ".xml");
                    FileInputStream is = null;
                    FileOutputStream os = null;
                    try {
                        is = new FileInputStream(xml);
                        os = new FileOutputStream(xmlCopy);
                        IOTools.flow(is, os);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    catch (IOException iOException) {}
                    context.setConfigFile(xmlCopy.toURI().toURL());
                } else {
                    context.setConfigFile(xml.toURI().toURL());
                }
            } else {
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(file);
            this.host.addChild(context);
            deployedApp.redeployResources.put(dir.getAbsolutePath(), dir.lastModified());
            if (this.deployXML && xml.exists()) {
                if (xmlCopy == null) {
                    deployedApp.redeployResources.put(xml.getAbsolutePath(), xml.lastModified());
                } else {
                    deployedApp.redeployResources.put(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                }
            }
            this.addWatchedResources(deployedApp, dir.getAbsolutePath(), context);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("hostConfig.deployDir.error", file), t);
        }
        this.deployed.put(cn.getName(), deployedApp);
    }

    protected boolean deploymentExists(String contextName) {
        return this.deployed.containsKey(contextName) || this.host.findChild(contextName) != null;
    }

    /*
     * Unable to fully structure code
     */
    protected void addWatchedResources(DeployedApplication app, String docBase, Context context) {
        docBaseFile = null;
        if (docBase != null && !(docBaseFile = new File(docBase)).isAbsolute()) {
            docBaseFile = new File(this.appBase(), docBase);
        }
        watchedResources = context.findWatchedResources();
        i = 0;
        while (i < watchedResources.length) {
            resource = new File(watchedResources[i]);
            if (resource.isAbsolute()) ** GOTO lbl14
            if (docBase == null) {
                if (HostConfig.log.isDebugEnabled()) {
                    HostConfig.log.debug("Ignoring non-existent WatchedResource '" + resource.getAbsolutePath() + "'");
                }
            } else {
                resource = new File(docBaseFile, watchedResources[i]);
lbl14:
                // 2 sources

                if (HostConfig.log.isDebugEnabled()) {
                    HostConfig.log.debug("Watching WatchedResource '" + resource.getAbsolutePath() + "'");
                }
                app.reloadResources.put(resource.getAbsolutePath(), resource.lastModified());
            }
            ++i;
        }
    }

    protected synchronized void checkResources(DeployedApplication app) {
        long lastModified;
        File resource;
        String[] resources = app.redeployResources.keySet().toArray(new String[0]);
        int i = 0;
        while (i < resources.length) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug("Checking context[" + app.name + "] redeploy resource " + resource);
            }
            if (resource.exists()) {
                lastModified = app.redeployResources.get(resources[i]);
                if (!resource.isDirectory() && resource.lastModified() > lastModified) {
                    if (log.isInfoEnabled()) {
                        log.info(sm.getString("hostConfig.undeploy", app.name));
                    }
                    ContainerBase context = (ContainerBase)this.host.findChild(app.name);
                    try {
                        this.host.removeChild(context);
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        log.warn(sm.getString("hostConfig.context.remove", app.name), t);
                    }
                    int j = i + 1;
                    while (j < resources.length) {
                        try {
                            File current = new File(resources[j]);
                            current = current.getCanonicalFile();
                            if (current.getAbsolutePath().startsWith(String.valueOf(this.appBase().getAbsolutePath()) + File.separator) || current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Delete " + current);
                                }
                                ExpandWar.delete(current);
                            }
                        }
                        catch (IOException e) {
                            log.warn(sm.getString("hostConfig.canonicalizing", app.name), e);
                        }
                        ++j;
                    }
                    this.deployed.remove(app.name);
                    return;
                }
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                if (!resource.exists() && (lastModified = app.redeployResources.get(resources[i]).longValue()) != 0L) {
                    if (log.isInfoEnabled()) {
                        log.info(sm.getString("hostConfig.undeploy", app.name));
                    }
                    ContainerBase context = (ContainerBase)this.host.findChild(app.name);
                    try {
                        this.host.removeChild(context);
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        log.warn(sm.getString("hostConfig.context.remove", app.name), t);
                    }
                    int j = i + 1;
                    while (j < resources.length) {
                        try {
                            File current = new File(resources[j]);
                            current = current.getCanonicalFile();
                            if (current.getAbsolutePath().startsWith(String.valueOf(this.appBase().getAbsolutePath()) + File.separator) || current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Delete " + current);
                                }
                                ExpandWar.delete(current);
                            }
                        }
                        catch (IOException e) {
                            log.warn(sm.getString("hostConfig.canonicalizing", app.name), e);
                        }
                        ++j;
                    }
                    String[] resources2 = app.reloadResources.keySet().toArray(new String[0]);
                    int j2 = 0;
                    while (j2 < resources2.length) {
                        try {
                            File current = new File(resources2[j2]);
                            current = current.getCanonicalFile();
                            if (current.getAbsolutePath().startsWith(String.valueOf(this.appBase().getAbsolutePath()) + File.separator) || current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath()) && current.getAbsolutePath().endsWith(".xml")) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Delete " + current);
                                }
                                ExpandWar.delete(current);
                            }
                        }
                        catch (IOException e) {
                            log.warn(sm.getString("hostConfig.canonicalizing", app.name), e);
                        }
                        ++j2;
                    }
                    this.deployed.remove(app.name);
                    return;
                }
            }
            ++i;
        }
        resources = app.reloadResources.keySet().toArray(new String[0]);
        i = 0;
        while (i < resources.length) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug("Checking context[" + app.name + "] reload resource " + resource);
            }
            lastModified = app.reloadResources.get(resources[i]);
            if (!resource.exists() && lastModified != 0L || resource.lastModified() != lastModified) {
                if (log.isInfoEnabled()) {
                    log.info(sm.getString("hostConfig.reload", app.name));
                }
                Container context = this.host.findChild(app.name);
                try {
                    if (context.getState().isAvailable()) {
                        context.stop();
                    }
                }
                catch (Exception e) {
                    log.warn(sm.getString("hostConfig.context.restart", app.name), e);
                }
                try {
                    context.start();
                }
                catch (Exception e) {
                    log.warn(sm.getString("hostConfig.context.restart", app.name), e);
                }
                app.reloadResources.put(resources[i], resource.lastModified());
                app.timestamp = System.currentTimeMillis();
                return;
            }
            ++i;
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("hostConfig.start"));
        }
        try {
            ObjectName hostON = this.host.getObjectName();
            this.oname = new ObjectName(String.valueOf(hostON.getDomain()) + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception e) {
            log.error(sm.getString("hostConfig.jmx.register", this.oname), e);
        }
        if (this.host.getCreateDirs()) {
            File[] dirs = new File[]{this.appBase(), this.configBase()};
            int i = 0;
            while (i < dirs.length) {
                if (!dirs[i].exists() && !dirs[i].mkdirs()) {
                    log.error(sm.getString("hostConfig.createDirs", dirs[i]));
                }
                ++i;
            }
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("hostConfig.stop"));
        }
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error(sm.getString("hostConfig.jmx.unregister", this.oname), e);
            }
        }
        this.oname = null;
        this.appBase = null;
        this.configBase = null;
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
            int i = 0;
            while (i < apps.length) {
                if (!this.isServiced(apps[i].name)) {
                    this.checkResources(apps[i]);
                }
                ++i;
            }
            this.deployApps();
        }
    }

    public void check(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app != null) {
            this.checkResources(app);
        } else {
            this.deployApps(name);
        }
    }

    public void manageApp(Context context) {
        File docBase;
        String contextName = context.getName();
        if (this.deployed.containsKey(contextName)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextName);
        boolean isWar = false;
        if (context.getDocBase() != null) {
            docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(this.appBase(), context.getDocBase());
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
            if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                isWar = true;
            }
        }
        this.host.addChild(context);
        if (isWar && this.unpackWARs) {
            docBase = new File(this.appBase(), context.getBaseName());
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), docBase.lastModified());
            this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApp, null, context);
        }
        this.deployed.put(contextName, deployedApp);
    }

    public void unmanageApp(String contextName) {
        if (this.isServiced(contextName)) {
            this.deployed.remove(contextName);
            this.host.removeChild(this.host.findChild(contextName));
        }
    }

    protected static class DeployedApplication {
        public String name;
        public LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();

        public DeployedApplication(String name) {
            this.name = name;
        }
    }
}

