/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.fileupload.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.eclipse.rap.addons.fileupload.FileUploadHandler;
import org.eclipse.rap.addons.fileupload.FileUploadReceiver;
import org.eclipse.rap.addons.fileupload.internal.CleaningTracker;
import org.eclipse.rap.addons.fileupload.internal.FileDetailsImpl;
import org.eclipse.rap.addons.fileupload.internal.FileUploadTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileUploadProcessor {
    private final FileUploadHandler handler;
    private final FileUploadTracker tracker;
    private final CleaningTracker cleaningTracker;

    FileUploadProcessor(FileUploadHandler handler) {
        this.handler = handler;
        this.tracker = new FileUploadTracker(handler);
        this.cleaningTracker = new CleaningTracker();
    }

    void handleFileUpload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            List<FileItem> fileItems = this.readUploadedFileItems(request);
            if (!fileItems.isEmpty()) {
                FileUploadReceiver receiver = this.handler.getReceiver();
                for (FileItem fileItem : fileItems) {
                    String fileName = FileUploadProcessor.stripFileName(fileItem.getName());
                    String contentType = fileItem.getContentType();
                    long contentLength = fileItem.getSize();
                    FileDetailsImpl details = new FileDetailsImpl(fileName, contentType, contentLength);
                    receiver.receive(fileItem.getInputStream(), details);
                    this.tracker.addFile(details);
                }
                this.tracker.handleFinished();
            } else {
                String errorMessage = "No file upload data found in request";
                this.tracker.setException(new Exception(errorMessage));
                this.tracker.handleFailed();
                response.sendError(400, errorMessage);
            }
        }
        catch (FileUploadBase.FileSizeLimitExceededException exception) {
            this.tracker.setException((Exception)((Object)exception));
            this.tracker.handleFailed();
            response.sendError(413, exception.getMessage());
        }
        catch (Exception exception) {
            this.tracker.setException(exception);
            this.tracker.handleFailed();
            response.sendError(500, exception.getMessage());
        }
        this.cleaningTracker.deleteTemporaryFiles();
    }

    private List<FileItem> readUploadedFileItems(HttpServletRequest request) throws FileUploadException {
        ArrayList<FileItem> result = new ArrayList<FileItem>();
        ServletFileUpload upload = this.createUpload();
        List uploadedItems = upload.parseRequest(request);
        for (Object uploadedItem : uploadedItems) {
            FileItem fileItem = (FileItem)uploadedItem;
            if (fileItem.isFormField()) continue;
            result.add(fileItem);
        }
        return result;
    }

    private ServletFileUpload createUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setFileCleaningTracker((FileCleaningTracker)this.cleaningTracker);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax(this.handler.getMaxFileSize());
        upload.setProgressListener(this.createProgressListener());
        return upload;
    }

    private ProgressListener createProgressListener() {
        ProgressListener result = new ProgressListener(){
            long prevTotalBytesRead = -1L;

            public void update(long totalBytesRead, long contentLength, int item) {
                if (totalBytesRead > this.prevTotalBytesRead) {
                    this.prevTotalBytesRead = totalBytesRead;
                    FileUploadProcessor.this.tracker.setContentLength(contentLength);
                    FileUploadProcessor.this.tracker.setBytesRead(totalBytesRead);
                    FileUploadProcessor.this.tracker.handleProgress();
                }
            }
        };
        return result;
    }

    private static String stripFileName(String name) {
        String result = name;
        int lastSlash = result.lastIndexOf(47);
        if (lastSlash != -1) {
            result = result.substring(lastSlash + 1);
        } else {
            int lastBackslash = result.lastIndexOf(92);
            if (lastBackslash != -1) {
                result = result.substring(lastBackslash + 1);
            }
        }
        return result;
    }
}

