/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.autosuggest.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;

public final class ModelResources {
    public static final String SCRIPT = "rwt/remote/Model.js";
    private static final boolean DEBUG = true;

    public static void ensure() {
        ModelResources.ensureRegistered();
        ModelResources.ensureLoaded();
    }

    private static void ensureRegistered() {
        if (RWT.getResourceManager().isRegistered(SCRIPT)) {
            ModelResources.deregister();
        }
        if (!RWT.getResourceManager().isRegistered(SCRIPT)) {
            try {
                ModelResources.register();
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to register resources", exception);
            }
        }
    }

    private static void ensureLoaded() {
        JavaScriptLoader loader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
        loader.require(RWT.getResourceManager().getLocation(SCRIPT));
    }

    private static void register() throws IOException {
        InputStream inputStream = ModelResources.getResourceAsStream(SCRIPT);
        try {
            RWT.getResourceManager().register(SCRIPT, inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private static void deregister() {
        RWT.getResourceManager().unregister(SCRIPT);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        ClassLoader classLoader = ModelResources.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new RuntimeException("Resource not found: " + resourceName);
        }
        return inputStream;
    }

    private ModelResources() {
    }
}

