/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.List;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class RadialLayoutAlgorithm
extends TreeLayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree;
    private double endDegree;
    private TreeLayoutAlgorithm treeLayout;
    private List roots;
    DisplayIndependentRectangle layoutBounds = null;

    public RadialLayoutAlgorithm() {
        this(0);
    }

    public RadialLayoutAlgorithm(int styles) {
        super(styles);
        this.treeLayout = new TreeLayoutAlgorithm(styles);
        this.startDegree = 0.0;
        this.endDegree = Math.PI * 2;
    }

    public void setLayoutArea(double x, double y, double width, double height) {
        throw new RuntimeException("Operation not implemented");
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
        if (asynchronous && continueous) {
            return false;
        }
        if (asynchronous && !continueous) {
            return true;
        }
        if (!asynchronous && continueous) {
            return false;
        }
        return !asynchronous && !continueous;
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        this.layoutBounds = new DisplayIndependentRectangle(x, y, width, height);
        super.preLayoutAlgorithm(entitiesToLayout, relationshipsToConsider, x, y, width, height);
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        this.roots = this.treeLayout.getRoots();
        this.computeRadialPositions(entitiesToLayout, this.layoutBounds);
        this.defaultFitWithinBounds(entitiesToLayout, this.layoutBounds);
        super.postLayoutAlgorithm(entitiesToLayout, relationshipsToConsider);
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    protected void computeRadialPositions(InternalNode[] entities, DisplayIndependentRectangle bounds2) {
        DisplayIndependentRectangle bounds = new DisplayIndependentRectangle(this.getLayoutBounds(entities, true));
        bounds.height = bounds2.height;
        bounds.y = bounds2.y;
        int i = 0;
        while (i < entities.length) {
            InternalNode entity = entities[i];
            double percentTheta = (entity.getInternalX() - bounds.x) / bounds.width;
            double distance = (entity.getInternalY() - bounds.y) / bounds.height;
            double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percentTheta;
            double newX = distance * Math.cos(theta);
            double newY = distance * Math.sin(theta);
            entity.setInternalLocation(newX, newY);
            ++i;
        }
    }

    protected DisplayIndependentRectangle getLayoutBounds(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
        DisplayIndependentRectangle layoutBounds = super.getLayoutBounds(entitiesToLayout, includeNodeSize);
        DisplayIndependentPoint centerPoint = this.roots != null ? this.determineCenterPoint(this.roots) : new DisplayIndependentPoint(layoutBounds.x + layoutBounds.width / 2.0, layoutBounds.y + layoutBounds.height / 2.0);
        double maxDistanceX = Math.max(Math.abs(layoutBounds.x + layoutBounds.width - centerPoint.x), Math.abs(centerPoint.x - layoutBounds.x));
        double maxDistanceY = Math.max(Math.abs(layoutBounds.y + layoutBounds.height - centerPoint.y), Math.abs(centerPoint.y - layoutBounds.y));
        layoutBounds = new DisplayIndependentRectangle(centerPoint.x - maxDistanceX, centerPoint.y - maxDistanceY, maxDistanceX * 2.0, maxDistanceY * 2.0);
        return layoutBounds;
    }

    private DisplayIndependentPoint determineCenterPoint(List roots) {
        double totalX = 0.0;
        double totalY = 0.0;
        for (InternalNode entity : roots) {
            totalX += entity.getInternalX();
            totalY += entity.getInternalY();
        }
        return new DisplayIndependentPoint(totalX / (double)roots.size(), totalY / (double)roots.size());
    }
}

