/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridcolumnkit;

import java.util.Arrays;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridColumnOperationHandler
extends WidgetOperationHandler<GridColumn> {
    private static final String METHOD_MOVE = "move";
    private static final String METHOD_RESIZE = "resize";
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";

    public GridColumnOperationHandler(GridColumn column) {
        super((Widget)column);
    }

    public void handleCall(GridColumn column, String method, JsonObject properties) {
        if (METHOD_MOVE.equals(method)) {
            this.handleCallMove(column, properties);
        } else if (METHOD_RESIZE.equals(method)) {
            this.handleCallResize(column, properties);
        }
    }

    public void handleNotify(GridColumn column, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(column, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(column, properties);
        } else {
            super.handleNotify((Widget)column, eventName, properties);
        }
    }

    public void handleCallMove(final GridColumn column, JsonObject properties) {
        final int newLeft = properties.get(PROP_LEFT).asInt();
        ProcessActionRunner.add((Runnable)new Runnable(){

            public void run() {
                GridColumnOperationHandler.moveColumn(column, newLeft);
            }
        });
    }

    public void handleCallResize(final GridColumn column, JsonObject properties) {
        final int width = properties.get(PROP_WIDTH).asInt();
        ProcessActionRunner.add((Runnable)new Runnable(){

            public void run() {
                column.setWidth(width);
            }
        });
    }

    public void handleNotifySelection(GridColumn column, JsonObject properties) {
        Event event = GridColumnOperationHandler.createSelectionEvent((int)13, (JsonObject)properties);
        column.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(GridColumn column, JsonObject properties) {
        Event event = GridColumnOperationHandler.createSelectionEvent((int)14, (JsonObject)properties);
        column.notifyListeners(14, event);
    }

    static void moveColumn(GridColumn column, int newLeft) {
        Grid grid = column.getParent();
        int index = grid.indexOf(column);
        int targetColumn = GridColumnOperationHandler.findMoveTarget(grid, newLeft);
        int[] columnOrder = grid.getColumnOrder();
        int orderIndex = GridColumnOperationHandler.arrayIndexOf(columnOrder, index);
        columnOrder = GridColumnOperationHandler.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (Arrays.equals(columnOrder = GridColumnOperationHandler.arrayInsert(columnOrder, targetColumn, index), grid.getColumnOrder())) {
            GridColumn[] columns = grid.getColumns();
            int i = 0;
            while (i < columns.length) {
                WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)columns[i]);
                adapter.preserve(PROP_LEFT, null);
                ++i;
            }
        } else {
            try {
                try {
                    grid.setColumnOrder(columnOrder);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
                    adapter.preserve(PROP_LEFT, null);
                }
            }
            finally {
                WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
                adapter.preserve(PROP_LEFT, null);
            }
        }
    }

    private static int findMoveTarget(Grid grid, int newLeft) {
        int result = -1;
        GridColumn[] columns = grid.getColumns();
        int[] columnOrder = grid.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                GridColumn column = columns[columnOrder[i]];
                int left = GridColumnOperationHandler.getLeft(column);
                int width = GridColumnOperationHandler.getWidth(column);
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int getLeft(GridColumn column) {
        return GridColumnOperationHandler.getGridAdapter(column).getCellLeft(GridColumnOperationHandler.getIndex(column));
    }

    private static int getWidth(GridColumn column) {
        return GridColumnOperationHandler.getGridAdapter(column).getCellWidth(GridColumnOperationHandler.getIndex(column));
    }

    private static int getIndex(GridColumn column) {
        return column.getParent().indexOf(column);
    }

    private static IGridAdapter getGridAdapter(GridColumn column) {
        return column.getParent().getAdapter(IGridAdapter.class);
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

