/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.griditemkit;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridItemOperationHandler
extends WidgetOperationHandler<GridItem> {
    private static final String PROP_CELL_CHECKED = "cellChecked";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_HEIGHT = "height";

    public GridItemOperationHandler(GridItem item) {
        super((Widget)item);
    }

    public void handleSet(GridItem item, JsonObject properties) {
        this.handleSetChecked(item, properties);
        this.handleSetExpanded(item, properties);
        this.handleSetHeight(item, properties);
    }

    public void handleSetChecked(GridItem item, JsonObject properties) {
        JsonValue value = properties.get(PROP_CELL_CHECKED);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            int i = 0;
            while (i < arrayValue.size()) {
                item.setChecked(i, arrayValue.get(i).asBoolean());
                ++i;
            }
        }
    }

    public void handleSetExpanded(final GridItem item, JsonObject properties) {
        final JsonValue expanded = properties.get(PROP_EXPANDED);
        if (expanded != null) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    item.setExpanded(expanded.asBoolean());
                    WidgetLCAUtil.preserveProperty((Widget)item, (String)GridItemOperationHandler.PROP_EXPANDED, (boolean)item.isExpanded());
                }
            });
        }
    }

    public void handleSetHeight(GridItem item, JsonObject properties) {
        JsonValue value = properties.get(PROP_HEIGHT);
        if (value != null) {
            item.setHeight(value.asInt());
        }
    }
}

