/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties.tabbed;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public final class TabContents {
    private ISection[] sections;
    private boolean controlsCreated = false;

    public int getSectionIndex(ISection section) {
        int i = 0;
        while (i < this.sections.length) {
            if (section == this.sections[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ISection getSectionAtIndex(int i) {
        if (i >= 0 && i < this.sections.length) {
            return this.sections[i];
        }
        return null;
    }

    public ISection[] getSections() {
        return this.sections;
    }

    public void createControls(Composite parent, final TabbedPropertySheetPage page) {
        Composite pageComposite = page.getWidgetFactory().createComposite(parent, 524288);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        pageComposite.setLayout((Layout)layout);
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            final Composite sectionComposite = page.getWidgetFactory().createComposite(pageComposite, 524288);
            sectionComposite.setLayout((Layout)new FillLayout());
            int style = section.shouldUseExtraSpace() ? 1808 : 768;
            GridData data = new GridData(style);
            data.heightHint = section.getMinimumHeight();
            sectionComposite.setLayoutData((Object)data);
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.createControls(sectionComposite, page);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
        this.controlsCreated = true;
    }

    public void dispose() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.dispose();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void aboutToBeShown() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeShown();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void aboutToBeHidden() {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeHidden();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void setInput(final IWorkbenchPart part, final ISelection selection) {
        int i = 0;
        while (i < this.sections.length) {
            final ISection section = this.sections[i];
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.setInput(part, selection);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public void setSections(ISection[] sections) {
        this.sections = sections;
    }

    public boolean controlsHaveBeenCreated() {
        return this.controlsCreated;
    }

    public void refresh() {
        if (this.controlsCreated) {
            int i = 0;
            while (i < this.sections.length) {
                final ISection section = this.sections[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        section.refresh();
                    }
                };
                SafeRunnable.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }
}

