/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.thread.Invocable;

public interface HttpChannel
extends Invocable {
    public ConnectionMetaData getConnectionMetaData();

    public void setHttpStream(HttpStream var1);

    public boolean isRequestHandled();

    public Runnable onRequest(MetaData.Request var1);

    public Request getRequest();

    public Runnable onContentAvailable();

    public Runnable onIdleTimeout(TimeoutException var1);

    public Runnable onFailure(Throwable var1);

    public void recycle();

    public void initialize();

    public ComplianceViolation.Listener getComplianceViolationListener();

    public static HttpChannel from(Request request) {
        Components components = Request.unWrap(request).getComponents();
        if (components instanceof HttpChannel) {
            HttpChannel httpChannel = (HttpChannel)((Object)components);
            return httpChannel;
        }
        throw new IllegalStateException("Unable to find HttpChannel from " + String.valueOf(request));
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public HttpChannel newHttpChannel(ConnectionMetaData connectionMetaData) {
            return new HttpChannelState(connectionMetaData);
        }
    }

    public static interface Factory {
        public HttpChannel newHttpChannel(ConnectionMetaData var1);
    }
}

