/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class S2eScoutTier
implements Predicate<IJavaElement> {
    private final ScoutTier m_tier;

    private S2eScoutTier(ScoutTier t) {
        this.m_tier = t;
    }

    public ScoutTier unwrap() {
        return this.m_tier;
    }

    public Optional<IJavaProject> convert(ScoutTier to, IJavaProject origin) {
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        String originJavaProjectName = origin.getElementName();
        IJavaProject project = origin.getJavaModel().getJavaProject(this.unwrap().convert(to, originJavaProjectName));
        if (!JdtUtils.exists((IJavaElement)project)) {
            return Optional.empty();
        }
        Optional<ScoutTier> projectTier = S2eScoutTier.valueOf((IJavaElement)project).map(S2eScoutTier::unwrap);
        if (!projectTier.isPresent()) {
            return Optional.empty();
        }
        if (to == projectTier.get()) {
            return Optional.of(project);
        }
        return Optional.empty();
    }

    public Optional<IPackageFragment> convert(ScoutTier to, IPackageFragment origin) {
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        Optional<IPackageFragmentRoot> targetSrcFolder = this.convert(to, JdtUtils.getSourceFolder((IJavaElement)origin));
        if (!targetSrcFolder.isPresent()) {
            return Optional.empty();
        }
        String name = this.unwrap().convert(to, origin.getElementName());
        IPackageFragment packageFragment = targetSrcFolder.get().getPackageFragment(name);
        if (JdtUtils.exists((IJavaElement)packageFragment)) {
            return Optional.of(packageFragment);
        }
        return Optional.empty();
    }

    public Optional<IPackageFragmentRoot> convert(ScoutTier to, IPackageFragmentRoot origin) {
        IJavaElement element;
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        Optional<IJavaProject> targetProject = this.convert(to, origin.getJavaProject());
        if (!targetProject.isPresent()) {
            return Optional.empty();
        }
        String projectRelResourcePath = origin.getPath().removeFirstSegments(1).toString();
        IFolder folder = targetProject.get().getProject().getFolder(projectRelResourcePath);
        if (folder != null && folder.exists() && JdtUtils.exists(element = JavaCore.create((IFolder)folder)) && element.getElementType() == 3) {
            return Optional.of((IPackageFragmentRoot)element);
        }
        return S2eUtils.primarySourceFolder(targetProject.get());
    }

    public static S2eScoutTier wrap(ScoutTier t) {
        return new S2eScoutTier((ScoutTier)Ensure.notNull((Object)t));
    }

    public static Optional<S2eScoutTier> valueOf(IJavaElement t) {
        if (!JdtUtils.exists(t)) {
            return Optional.empty();
        }
        Optional tier = ScoutTier.valueOf((T fqn) -> JdtUtils.exists((IJavaElement)S2eScoutTier.lookupJdtType(t, fqn)));
        return tier.map(S2eScoutTier::wrap);
    }

    static IType lookupJdtType(IJavaElement t, String fqn) {
        try {
            return t.getJavaProject().findType(fqn);
        }
        catch (JavaModelException ex) {
            throw new SdkException((Throwable)ex);
        }
    }

    @Override
    public boolean test(IJavaElement t) {
        Optional<S2eScoutTier> tier = S2eScoutTier.valueOf(t);
        return tier.filter(s2eScoutTier -> this.unwrap().isIncludedIn(s2eScoutTier.unwrap())).isPresent();
    }

    public int hashCode() {
        return this.m_tier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        S2eScoutTier other = (S2eScoutTier)obj;
        return this.m_tier == other.m_tier;
    }

    public String toString() {
        return this.m_tier.toString();
    }
}

