/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.derived;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.s.derived.DtoUpdateHandler;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceHandler;
import org.eclipse.scout.sdk.s2e.derived.DerivedResourceInputWithJdt;
import org.eclipse.scout.sdk.s2e.derived.IDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class DtoDerivedResourceHandlerFactory
implements IDerivedResourceHandlerFactory {
    @Override
    public List<IDerivedResourceHandler> createHandlersFor(Set<IResource> resources, IJavaSearchScope searchScope) throws JavaModelException {
        HashSet<IType> baseTypes = new HashSet<IType>();
        DtoDerivedResourceHandlerFactory.findScopeCandidates(searchScope, baseTypes);
        DtoDerivedResourceHandlerFactory.findResourceCandidates(resources, baseTypes);
        if (baseTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return baseTypes.stream().map(DerivedResourceInputWithJdt::new).map(DtoUpdateHandler::new).collect(Collectors.toList());
    }

    protected static void findResourceCandidates(Iterable<IResource> resources, Collection<IType> collector) throws JavaModelException {
        for (IResource r : resources) {
            IJavaElement javaElement = JavaCore.create((IResource)r);
            if (!JdtUtils.exists(javaElement) || javaElement.getElementType() != 5) continue;
            ICompilationUnit icu = (ICompilationUnit)javaElement;
            IType[] iTypeArray = icu.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType candidate = iTypeArray[n2];
                if (DtoDerivedResourceHandlerFactory.acceptType(candidate) && JdtUtils.exists((IJavaElement)JdtUtils.getFirstAnnotationInSupertypeHierarchy(candidate, "org.eclipse.scout.rt.client.dto.Data", "org.eclipse.scout.rt.client.dto.FormData", "org.eclipse.scout.rt.client.dto.PageData"))) {
                    collector.add(candidate);
                }
                ++n2;
            }
        }
    }

    protected static void findScopeCandidates(IJavaSearchScope scope, Collection<IType> collector) throws JavaModelException {
        if (scope == null) {
            return;
        }
        for (IType candidate : JdtUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.Data", scope, null)) {
            if (!DtoDerivedResourceHandlerFactory.acceptType(candidate)) continue;
            collector.add(candidate);
        }
        for (IType candidate : JdtUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.FormData", scope, null)) {
            if (!DtoDerivedResourceHandlerFactory.acceptType(candidate)) continue;
            collector.add(candidate);
        }
        for (IType candidate : JdtUtils.findAllTypesAnnotatedWith("org.eclipse.scout.rt.client.dto.PageData", scope, null)) {
            if (!DtoDerivedResourceHandlerFactory.acceptType(candidate)) continue;
            collector.add(candidate);
        }
    }

    protected static boolean acceptType(IType jdtType) throws JavaModelException {
        return JdtUtils.exists((IJavaElement)jdtType) && JdtUtils.exists((IJavaElement)jdtType.getJavaProject()) && !jdtType.isAnonymous() && !jdtType.isBinary() && jdtType.getDeclaringType() == null && Flags.isPublic((int)jdtType.getFlags());
    }
}

