/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.s.util.search.FileRange;
import org.eclipse.scout.sdk.core.s.util.search.IFileQueryResult;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.util.EclipseWorkspaceWalker;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eScoutTier;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class S2eUiUtils {
    private S2eUiUtils() {
    }

    public static PackageContainer getClientPackageOfSelection(ISelection selection) {
        Comparator<IJavaElement> elementComparator = new Comparator<IJavaElement>(){

            @Override
            public int compare(IJavaElement o1, IJavaElement o2) {
                int result = Integer.compare(this.getRanking(o1), this.getRanking(o2));
                if (result != 0) {
                    return result;
                }
                result = o1.getElementName().compareTo(o2.getElementName());
                if (result != 0) {
                    return result;
                }
                return o1.toString().compareTo(o2.toString());
            }

            private int getRanking(IJavaElement element) {
                Optional tier = S2eScoutTier.valueOf((IJavaElement)element);
                if (!tier.isPresent()) {
                    return 100;
                }
                switch (((S2eScoutTier)tier.get()).unwrap()) {
                    case Client: {
                        return 5;
                    }
                    case HtmlUi: {
                        return 10;
                    }
                }
                return 15;
            }
        };
        return S2eUiUtils.getPackageOfSelection(selection, elementComparator, S2eScoutTier.wrap((ScoutTier)ScoutTier.Client));
    }

    public static PackageContainer getSharedPackageOfSelection(ISelection selection) {
        Comparator<IJavaElement> elementComparator = Comparator.comparing(IJavaElement::getElementName).thenComparing(Object::toString);
        return S2eUiUtils.getPackageOfSelection(selection, elementComparator, S2eScoutTier.wrap((ScoutTier)ScoutTier.Shared));
    }

    public static IEditorPart openInEditor(IType type, boolean activate) {
        if (type == null) {
            return null;
        }
        return S2eUiUtils.openInEditor((IJavaElement)EclipseEnvironment.toJdtType((IType)type), activate);
    }

    public static IEditorPart openInEditor(IJavaElement je, boolean activate) {
        if (!JdtUtils.exists((IJavaElement)je)) {
            return null;
        }
        try {
            return JavaUI.openInEditor((IJavaElement)je, (boolean)activate, (boolean)true);
        }
        catch (JavaModelException | PartInitException ex) {
            SdkLog.info((String)"Unable to open java editor for input '{}'.", (Object[])new Object[]{je.getElementName(), ex});
            return null;
        }
    }

    public static IEditorPart openInEditor(IFile f, boolean activate) {
        return S2eUiUtils.openInEditor(f, null, activate);
    }

    public static IEditorPart openInEditor(IFile f, String editorId, boolean activate) {
        return S2eUiUtils.openInEditor(f, null, editorId, activate);
    }

    public static IEditorPart openInEditor(IEditorInput input, String editorId, boolean activate) {
        return S2eUiUtils.openInEditor(null, input, editorId, activate);
    }

    public static IEditorPart openInEditor(Path file, boolean activate) {
        if (file == null) {
            return null;
        }
        return S2eUtils.findFileInWorkspace((URI)file.toUri()).map(f -> S2eUiUtils.openInEditor(f, activate)).orElse(null);
    }

    private static IEditorPart openInEditor(IFile f, IEditorInput input, String editorId, boolean activate) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        try {
            if (input != null) {
                return IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)editorId, (boolean)activate);
            }
            if (f != null) {
                if (editorId != null) {
                    return IDE.openEditor((IWorkbenchPage)activePage, (IFile)f, (String)editorId, (boolean)activate);
                }
                return IDE.openEditor((IWorkbenchPage)activePage, (IFile)f, (boolean)activate);
            }
        }
        catch (PartInitException e) {
            SdkLog.info((String)"Unable to open editor for input '{}'.", (Object[])new Object[]{f == null ? input : f, e});
        }
        return null;
    }

    private static PackageContainer getPackageOfSelection(ISelection selection, Comparator<IJavaElement> javaElementComparator, S2eScoutTier expected) {
        Set<IResource> selectedResources = S2eUiUtils.getResourcesOfSelection(selection);
        PackageContainer result = new PackageContainer();
        if (selectedResources.isEmpty()) {
            return result;
        }
        try {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>(selectedResources.size());
            ArrayList<IJavaElement> unaccepted = new ArrayList<IJavaElement>(selectedResources.size());
            for (IResource r : selectedResources) {
                IJavaElement element = JavaCore.create((IResource)r);
                if (!JdtUtils.exists((IJavaElement)element)) continue;
                if (expected.test(element)) {
                    elements.add(element);
                    continue;
                }
                unaccepted.add(element);
            }
            if (elements.isEmpty() && !unaccepted.isEmpty()) {
                Optional foundTier;
                PackageContainer unacceptedResult = new PackageContainer();
                S2eUiUtils.fillContainer(unaccepted, unacceptedResult, javaElementComparator);
                if (JdtUtils.exists((IJavaElement)unacceptedResult.getProject()) && (foundTier = S2eScoutTier.valueOf((IJavaElement)unacceptedResult.getProject())).isPresent()) {
                    ScoutTier expectedTier = expected.unwrap();
                    result.setProject(((S2eScoutTier)foundTier.get()).convert(expectedTier, unacceptedResult.getProject()).orElse(null));
                    result.setSrcFolder(((S2eScoutTier)foundTier.get()).convert(expectedTier, unacceptedResult.getSrcFolder()).orElse(null));
                    result.setPackage(((S2eScoutTier)foundTier.get()).convert(expectedTier, unacceptedResult.getPackage()).orElse(null));
                }
            } else {
                S2eUiUtils.fillContainer(elements, result, javaElementComparator);
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Unable to parse source folder of selection {}", (Object[])new Object[]{selection, e});
        }
        return result;
    }

    private static void fillContainer(List<IJavaElement> candidates, PackageContainer result, Comparator<IJavaElement> javaElementComparator) throws JavaModelException {
        IJavaProject javaProject;
        if (candidates.isEmpty()) {
            return;
        }
        candidates.sort(javaElementComparator);
        IJavaElement element = candidates.get(0);
        result.setPackage((IPackageFragment)element.getAncestor(4));
        IPackageFragmentRoot pckFragRoot = JdtUtils.getSourceFolder((IJavaElement)element);
        if (JdtUtils.exists((IJavaElement)pckFragRoot) && pckFragRoot.getKind() == 1) {
            result.setSrcFolder(pckFragRoot);
        }
        if (JdtUtils.exists((IJavaElement)(javaProject = (IJavaProject)element.getAncestor(2)))) {
            result.setProject(javaProject);
            if (result.getSrcFolder() == null) {
                result.setSrcFolder(S2eUtils.primarySourceFolder((IJavaProject)javaProject).orElse(null));
            }
        }
    }

    public static Set<IResource> getResourcesOfSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            IJavaElement activeEditorJavaInput = EditorUtility.getActiveEditorJavaInput();
            if (!JdtUtils.exists((IJavaElement)activeEditorJavaInput)) {
                return Collections.emptySet();
            }
            selection = new StructuredSelection((Object)activeEditorJavaInput);
        }
        IStructuredSelection structSel = (IStructuredSelection)selection;
        LinkedHashSet<IResource> resourceSet = new LinkedHashSet<IResource>(structSel.size());
        for (Object selElem : structSel) {
            if (selElem instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)selElem;
                if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) continue;
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable workingSetElement = iAdaptableArray[n2];
                    S2eUiUtils.addAdaptableResource(workingSetElement, resourceSet);
                    ++n2;
                }
                continue;
            }
            if (!(selElem instanceof IAdaptable)) continue;
            S2eUiUtils.addAdaptableResource((IAdaptable)selElem, resourceSet);
        }
        return resourceSet;
    }

    private static void addAdaptableResource(IAdaptable a, Collection<IResource> collector) {
        IResource resource = (IResource)a.getAdapter(IResource.class);
        if (resource != null && resource.isAccessible()) {
            collector.add(resource);
        }
    }

    public static IPackageFragmentRoot getTestSourceFolder(IJavaElement element, String fqnOfRequiredType, String testName) {
        IPackageFragmentRoot testSourceFolder;
        block5: {
            if (!JdtUtils.exists((IJavaElement)element)) {
                return null;
            }
            if (Strings.isBlank((CharSequence)testName)) {
                testName = "tests";
            }
            IJavaProject javaProject = element.getJavaProject();
            try {
                testSourceFolder = S2eUtils.getTestSourceFolder((IJavaProject)javaProject, (String)fqnOfRequiredType);
                if (JdtUtils.exists((IJavaElement)testSourceFolder)) break block5;
                S2eUiUtils.logNoTestSourceFolderFound(javaProject, fqnOfRequiredType, testName);
                return null;
            }
            catch (RuntimeException e) {
                SdkLog.warning((String)"Unable to calculate test source folder for project {}. No {} will be generated.", (Object[])new Object[]{javaProject.getElementName(), testName, e});
                return null;
            }
        }
        return testSourceFolder;
    }

    private static void logNoTestSourceFolderFound(IJavaProject javaProject, String fqnOfRequiredType, String testName) {
        try {
            IPackageFragmentRoot sourceFolderIgnoringRequiredType = S2eUtils.getTestSourceFolder((IJavaProject)javaProject, null);
            if (JdtUtils.exists((IJavaElement)sourceFolderIgnoringRequiredType)) {
                SdkLog.warning((String)"Could not find a test source folder for project '{}' having access to class '{}'. No {} will be generated.", (Object[])new Object[]{javaProject.getElementName(), fqnOfRequiredType, testName});
            }
            return;
        }
        catch (RuntimeException e) {
            SdkLog.debug((String)"Unable to get source folders for project '{}'.", (Object[])new Object[]{javaProject.getElementName(), e});
            SdkLog.warning((String)"No test source folder could be found for project '{}'. No {} will be generated.", (Object[])new Object[]{javaProject.getElementName(), testName});
            return;
        }
    }

    public static void showUrlInBrowser(String url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(URIUtil.fromString((String)url).toURL());
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException | PartInitException e) {
            SdkLog.warning((String)"Could not open default web browser.", (Object[])new Object[]{e});
        }
    }

    public static void queryResultToSearchResult(IFileQueryResult from, FileSearchResult to) {
        to.removeAll();
        from.result().map(S2eUiUtils::toEclipseMatch).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((FileSearchResult)to).addMatch(arg_0));
    }

    static Optional<Match> toEclipseMatch(FileRange range) {
        return new EclipseWorkspaceWalker.WorkspaceFile(range.file(), StandardCharsets.UTF_8).inWorkspace().map(iFile -> new Match(iFile, range.start(), range.length()));
    }
}

