/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.resource;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.IResourceChangedListener;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextEx;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.util.OptimisticLock;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;

public class ResourceTextField
extends TextField {
    private Button m_popupButton;
    private URL m_url;
    private boolean m_folderMode;
    private String[] m_filterExtensions;
    private String m_fileName;
    private final EventListenerList m_eventListeners;
    private final OptimisticLock m_inputLock = new OptimisticLock();

    public ResourceTextField(Composite parent) {
        this(parent, 1);
    }

    public ResourceTextField(Composite parent, int type) {
        this(parent, type, 150);
    }

    public ResourceTextField(Composite parent, int type, int labelWidth) {
        super(parent, type, labelWidth);
        this.m_eventListeners = new EventListenerList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(enabled);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(editable);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_popupButton = new Button(parent, 0x800008);
        this.m_popupButton.setText("Browse...");
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceTextField.this.showFileChooserDialog();
            }
        });
        StyledTextEx text = this.getTextComponent();
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                try {
                    if (ResourceTextField.this.m_inputLock.acquire()) {
                        ResourceTextField.this.setUrl(this.toUrl(ResourceTextField.this.getText()));
                    }
                }
                finally {
                    ResourceTextField.this.m_inputLock.release();
                }
            }

            public void focusGained(FocusEvent e) {
            }

            private URL toUrl(String path) {
                if (Strings.isBlank((CharSequence)path)) {
                    return null;
                }
                try {
                    Path newFile = Paths.get(path, new String[0]).toRealPath(new LinkOption[0]);
                    return newFile.toUri().toURL();
                }
                catch (Exception ex) {
                    try {
                        return new URL(path);
                    }
                    catch (MalformedURLException e1) {
                        SdkLog.debug((Object[])new Object[]{e1});
                        return null;
                    }
                }
            }
        });
        FormData textData = (FormData)text.getLayoutData();
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        FormData buttonData = new FormData();
        buttonData.width = 70;
        buttonData.top = new FormAttachment(0, -1);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    private void showFileChooserDialog() {
        String fileName;
        DirectoryDialog dialog;
        if (this.isFolderMode()) {
            dialog = new DirectoryDialog(this.getShell());
            Path urlAsPath = this.getFile();
            if (urlAsPath != null) {
                dialog.setFilterPath(urlAsPath.toString());
            }
            fileName = dialog.open();
        } else {
            dialog = new FileDialog(this.getShell());
            if (this.getFileName() != null) {
                dialog.setFileName(this.getFileName());
            }
            dialog.setOverwrite(true);
            if (this.getFilterExtensions() != null) {
                dialog.setFilterExtensions(this.getFilterExtensions());
            }
            if (!Strings.isEmpty((CharSequence)(fileName = dialog.open())) && this.getFilterExtensions() != null && this.getFilterExtensions().length > 0) {
                Matcher m = Pattern.compile("\\.([^.]*)$").matcher(fileName);
                String extension = null;
                if (m.find()) {
                    String fileNameExt = m.group(1);
                    String[] stringArray = this.getFilterExtensions();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fExt = stringArray[n2];
                        if (("*." + fileNameExt).equalsIgnoreCase(fExt)) {
                            extension = fileNameExt;
                            break;
                        }
                        ++n2;
                    }
                }
                int extIndex = dialog.getFilterIndex();
                if (extension == null && extIndex > -1 && extIndex < this.getFilterExtensions().length) {
                    extension = this.getFilterExtensions()[extIndex];
                    extension = Pattern.compile("\\**").matcher(extension).replaceFirst("");
                    fileName = String.valueOf(fileName) + extension;
                }
            }
        }
        Path newFile = null;
        if (Strings.hasText((CharSequence)fileName)) {
            newFile = Paths.get(fileName, new String[0]);
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(newFile.toString());
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
        this.setFile(newFile);
    }

    public void addResourceChangedListener(IResourceChangedListener listener) {
        this.m_eventListeners.add(IResourceChangedListener.class, listener);
    }

    public void removeResourceChangedListener(IResourceChangedListener listener) {
        this.m_eventListeners.remove(IResourceChangedListener.class, listener);
    }

    private void fireValueChanged() {
        Path newFile = this.getFile();
        URL newUrl = this.getUrl();
        IResourceChangedListener[] iResourceChangedListenerArray = (IResourceChangedListener[])this.m_eventListeners.getListeners(IResourceChangedListener.class);
        int n = iResourceChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceChangedListener l = iResourceChangedListenerArray[n2];
            l.resourceChanged(newUrl, newFile);
            ++n2;
        }
    }

    public boolean isFolderMode() {
        return this.m_folderMode;
    }

    public void setFolderMode(boolean folderMode) {
        this.m_folderMode = folderMode;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.m_filterExtensions = filterExtensions;
    }

    public String[] getFilterExtensions() {
        return this.m_filterExtensions;
    }

    public Path getFile() {
        URI uri;
        block4: {
            URL url = this.getUrl();
            if (url == null) {
                return null;
            }
            try {
                uri = url.toURI();
                if ("file".equalsIgnoreCase(uri.getScheme())) break block4;
                return null;
            }
            catch (URISyntaxException e) {
                SdkLog.debug((String)"Ignoring invalid file URI.", (Object[])new Object[]{e});
                return null;
            }
        }
        return Paths.get(uri);
    }

    public URL getUrl() {
        return this.m_url;
    }

    public void setUrl(URL url) {
        if (Objects.equals(url, this.m_url)) {
            return;
        }
        this.m_url = url;
        this.fireValueChanged();
    }

    public void setFile(Path file) {
        String text;
        if (file == null) {
            text = "";
            this.setUrl(null);
        } else {
            text = file.toAbsolutePath().toString();
            try {
                this.setUrl(file.toUri().toURL());
            }
            catch (MalformedURLException e) {
                SdkLog.warning((String)"Unable convert File to URL", (Object[])new Object[]{e});
            }
        }
        if (!this.isDisposed()) {
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(text);
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }
}

